% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bus-path.R
\name{bus_path}
\alias{bus_path}
\title{Bus Path Details}
\format{
A list with 4 elements:
\describe{
\item{RouteID}{Bus route variant.}
\item{Name}{Descriptive name for the route.}
\item{ShapePoint}{The coordinate path of the line in both directions.}
\item{Stops}{The coordinates of stops on a given line.}
}
}
\usage{
bus_path(RouteID, Date = NULL, api_key = wmata_key())
}
\arguments{
\item{RouteID}{Bus route variant, e.g.: 70, 10A, 10Av1.}

\item{Date}{Date for which to retrieve route and stop information. Uses
today's date if \code{NULL} (default).}

\item{api_key}{Subscription key which provides access to this API. Defaults
\code{Sys.getenv("WMATA_KEY")} via \code{\link[=wmata_key]{wmata_key()}}.}
}
\value{
A list with (1) set of ordered latitude/longitude points along a
route variant along with (2) the list of stops served.
}
\description{
For a given date, returns the set of ordered latitude/longitude points along
a route variant along with the list of stops served.
}
\examples{
\dontrun{
bus_path("70")
}
}
\seealso{
\url{https://developer.wmata.com/docs/services/54763629281d83086473f231/operations/5476362a281d830c946a3d69}

Other Bus Route and Stop Methods: 
\code{\link{bus_departs}()},
\code{\link{bus_position}()},
\code{\link{bus_routes}()},
\code{\link{bus_schedule}()},
\code{\link{bus_stops}()}
}
\concept{Bus Route and Stop Methods}
