% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_CCC.R
\name{CCC}
\alias{CCC}
\title{Concordance correlation coefficient (CCC)}
\usage{
CCC(data = NULL, obs, pred, tidy = FALSE, na.rm = TRUE)
}
\arguments{
\item{data}{(Optional) argument to call an existing data frame containing the data.}

\item{obs}{Vector with observed values (numeric).}

\item{pred}{Vector with predicted values (numeric).}

\item{tidy}{Logical operator (TRUE/FALSE) to decide the type of return. TRUE
returns a data.frame, FALSE returns a list; Default : FALSE.}

\item{na.rm}{Logic argument to remove rows with missing values
(NA). Default is na.rm = TRUE.}
}
\value{
an object of class \code{numeric} within a \code{list} (if tidy = FALSE) or within a
\verb{data frame} (if tidy = TRUE).
}
\description{
It estimates the Concordance Correlation Coefficient (CCC) for
a continuous predicted-observed dataset.
}
\details{
The CCC it is a normalized coefficient that tests general agreement.
It presents both precision (r) and accuracy (Xa) components. It is positively bounded to 1.
The closer to 1 the better. Values towards zero indicate low correlation between observations and predictions.
Negative values would indicate a negative relationship between predicted and observed.
For the formula and more details, see \href{https://adriancorrendo.github.io/metrica/articles/available_metrics_regression.html}{online-documentation}
}
\examples{
\donttest{
set.seed(1)
X <- rnorm(n = 100, mean = 0, sd = 10)
Y <- X + rnorm(n=100, mean = 0, sd = 3)
CCC(obs = X, pred = Y)
}
}
\references{
Lin (1989).
A concordance correlation coefficient to evaluate reproducibility.
\emph{Biometrics 45 (1), 255–268.} \doi{10.2307/2532051}
}
