% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics_summary.R
\name{metrics_summary}
\alias{metrics_summary}
\title{Prediction Performance Summary}
\usage{
metrics_summary(
  data = NULL,
  obs,
  pred,
  orientation = "PO",
  na.rm = TRUE,
  metrics_list = NULL
)
}
\arguments{
\item{data}{(Optional) argument to call an existing data frame containing the data.}

\item{obs}{vector with observed values (numeric).}

\item{pred}{vector with predicted values (numeric).}

\item{orientation}{argument of class string specifying the axis
orientation to estimate slope(B1) and intercept(B0).
"PO" is for predicted vs observed, and "OP" for observed vs predicted.
Default is orientation = "PO".}

\item{na.rm}{Logic argument to remove rows with missing values
(NA). Default is na.rm = TRUE.}

\item{metrics_list}{vector or list of specific selected metrics. Default is = NULL,
which will estimate all metrics available.}
}
\value{
an object of class \code{data.frame} containing all (or selected) metrics.
}
\description{
It estimates a group of metrics characterizing the prediction performance
for a continuous predicted-observed dataset. By default, it calculates all available metrics.
}
\details{
The user can choose to calculate a single metric, or to calculate all metrics at once.
This function creates a data.frame with all (or selected) metrics in the \code{metrica}-package.
If looking for specific metrics, the user can pass a list of desired metrics using the
argument “metrics_list” (e.g. metrics_list = c("R2","MAE", "RMSE", "RSR", "NSE", "KGE")).
For the entire list of available metrics with formula, see \href{https://adriancorrendo.github.io/metrica/articles/available_metrics.html}{online documentation}
}
\examples{
\donttest{
X <- rnorm(n = 100, mean = 0, sd = 10)
Y <- rnorm(n = 100, mean = 0, sd = 10)
df <- data.frame(obs = X, pred = Y)
metrics_summary(df, obs = X, pred = Y)
}
}
