\encoding{UTF-8}
\name{SpatialPixelsTopography-class}
\docType{class}
\alias{SpatialPixelsTopography-class}
\alias{[,SpatialPixelsTopography-method}
\alias{[,SpatialPixelsTopography,ANY,ANY-method}
\alias{show,SpatialPixelsTopography-method}

\title{Class \code{"SpatialPixelsTopography"}}
\description{
An S4 class that represents topography that has locations on a regular grid.
}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("SpatialPixelsTopography", ...)}, or by calls to the function \code{\link{SpatialPixelsTopography}}.
}
\section{Slots}{
  \describe{
    \item{\code{data}:}{Object of class \code{"data.frame"} containing the elevation (in m), slope (in degrees) and aspect (in degrees from North) of every cell.}
    \item{\code{coords.nrs}:}{Inherited from \code{SpatialPointsDataFrame} but not used.}
    \item{\code{grid}:}{Object of class \code{\link{GridTopology}}.  }
    \item{\code{grid.index}:}{Index of points in full grid.}
    \item{\code{coords}:}{Object of class \code{"matrix"} with the spatial coordinates. }
    \item{\code{bbox}:}{Object of class \code{"matrix"} with the boundary box. }
    \item{\code{proj4string}:}{Object of class \code{"CRS"} with the projection string.}
    }
}
\section{Extends}{
Class \code{"\linkS4class{SpatialPixelsDataFrame}"}, directly.
Class \code{"\linkS4class{SpatialPixels}"}, by class "SpatialPixelsDataFrame", distance 2.
Class \code{"\linkS4class{SpatialPointsDataFrame}"}, by class "SpatialPixelsDataFrame", distance 2.
Class \code{"\linkS4class{SpatialPoints}"}, by class "SpatialPixelsDataFrame", distance 3.
Class \code{"\linkS4class{Spatial}"}, by class "SpatialPixelsDataFrame", distance 4.
}

\usage{
  \S4method{[}{SpatialPixelsTopography,ANY,ANY}(x, i, j, ..., drop = FALSE)
  \S4method{show}{SpatialPixelsTopography}(object)
}
\arguments{
  \item{x,object}{\code{SpatialPixelsTopography} object}
  \item{i}{row indices}
  \item{j}{column indices}
  \item{drop}{see \code{\link[base]{Extract}}}
  \item{...}{indices passed through}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}

\seealso{
\code{\link{SpatialPixelsTopography}}, \code{\link{SpatialPixelsDataFrame-class}}
}
\examples{
#Structure of the S4 object
showClass("SpatialPixelsTopography")
}
\keyword{classes}
