% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solutions_matrix.R
\name{extend_solutions}
\alias{extend_solutions}
\title{Extend an solutions matrix to include outcome evaluations}
\usage{
extend_solutions(
  solutions_matrix,
  target_list = NULL,
  data_list = NULL,
  cat_test = "chi_squared",
  calculate_summaries = TRUE,
  min_pval = 1e-10,
  processes = 1,
  verbose = FALSE
)
}
\arguments{
\item{solutions_matrix}{Result of \code{batch_snf} storing cluster solutions and
the settings that were used to generate them.}

\item{target_list}{A data_list with features to calculate p-values for.
Features in the target list will be included during p-value summary
measure calculations.}

\item{data_list}{A data_list with features to calcualte p-values for, but
that should not be incorporated into p-value summary measure columns (i.e.,
min/mean/max p-value columns).}

\item{cat_test}{String indicating which statistical test will be used to
associate cluster with a categorical feature. Options are "chi_squared" for
the Chi-squared test and "fisher_exact" for Fisher's exact test.}

\item{calculate_summaries}{If TRUE, the function will calculate the minimum
and mean p-values for each row of the solutions matrix.}

\item{min_pval}{If assigned a value, any p-value less than this will be
replaced with this value.}

\item{processes}{The number of processes to use for parallelization.
Progress is only reported for sequential processing (processes = 1).}

\item{verbose}{If TRUE, print progress to console.}
}
\value{
extended_solutions_matrix an extended solutions matrix that contains
p-value columns for each outcome in the provided target_list
}
\description{
Extend an solutions matrix to include outcome evaluations
}
