% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/box.R
\name{boxplot_data_frame}
\alias{boxplot_data_frame}
\title{Boxplot Function for Data Frame}
\usage{
boxplot_data_frame(x, yvar, xvar, facets = NULL,
  log = getOption("metaplot_log", FALSE),
  horizontal = getOption("metaplot_horizontal", NULL),
  crit = getOption("metaplot_crit", 1.3),
  panel = getOption("metaplot_boxplot_panel", boxplot_panel),
  ref = getOption("metaplot_ref", metaplot_ref),
  ref.col = getOption("metaplot_ref.col", "grey"),
  ref.lty = getOption("metaplot_ref.lty", "solid"),
  ref.alpha = getOption("metaplot_ref.alpha", 1),
  nobs = getOption("metaplot_nobs", FALSE),
  na.rm = getOption("metaplot_na.rm", TRUE), xlab = NULL, ylab = NULL,
  numlab = getOption("metaplot_lab", axislabel),
  catlab = getOption("metaplot_lab", axislabel),
  aspect = getOption("metaplot_aspect", 1),
  main = getOption("metaplot_main", NULL), sub = getOption("metaplot_sub",
  NULL), ...)
}
\arguments{
\item{x}{data.frame}

\item{yvar}{y variable}

\item{xvar}{x variable}

\item{facets}{optional conditioning variables}

\item{log}{whether to log transform numeric variable (auto-selected if NULL)}

\item{horizontal}{whether box/whisker axis should be horizontal (numeric x, categorical y); defaults TRUE if (var[[2]] is numeric}

\item{crit}{if log is NULL, log-transform if mean/median ratio for non-missing x is greater than this value}

\item{panel}{panel function}

\item{ref}{optional reference line(s) on numeric axis; can be function(x = x, var = con, ...)}

\item{ref.col}{color for reference line(s)}

\item{ref.lty}{line type for reference line(s)}

\item{ref.alpha}{transparency for reference line(s)}

\item{nobs}{whether to include the number of observations under the category label}

\item{na.rm}{whether to remove data points with one or more missing coordinates}

\item{xlab}{x axis label}

\item{ylab}{y axis label}

\item{numlab}{numeric axis label; can be function(x = x, var = numvar, log = ylog, ...)}

\item{catlab}{categorical axis label; can be function(x = x, var = catvar, ...)}

\item{aspect}{passed to \code{\link[lattice]{bwplot}}}

\item{main}{character, or a function of x, yvar, xvar, facets, and log}

\item{sub}{character, or a function of x, yvar, xvar, facets, and log}

\item{...}{passed arguments}
}
\description{
Boxplot for data.frame. Creates a boxplot using \code{boxplot_panel} by default.
}
\examples{
library(magrittr)
library(dplyr)
boxplot_data_frame(Theoph,'Subject','conc')
boxplot_data_frame(Theoph \%>\% filter(conc > 0),
'conc','Subject', log = TRUE, ref = c(2,5),horizontal = FALSE)
}
\seealso{
Other mixedvariate plots: \code{\link{boxplot.data.frame}},
  \code{\link{boxplot_panel}}

Other boxplot: \code{\link{boxplot.data.frame}}

Other metaplot: \code{\link{corsplom_data_frame}},
  \code{\link{densplot_data_frame}},
  \code{\link{metaplot}}, \code{\link{scatter_data_frame}}
}
