% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_na.R
\name{utils_na}
\alias{utils_na}
\alias{remove_rows_na}
\alias{remove_cols_na}
\alias{select_cols_na}
\alias{select_rows_na}
\alias{has_na}
\alias{replace_na}
\alias{random_na}
\title{Utilities for handling with NA values}
\usage{
remove_rows_na(.data, verbose = TRUE)

remove_cols_na(.data, verbose = TRUE)

select_cols_na(.data, verbose = TRUE)

select_rows_na(.data, verbose = TRUE)

has_na(.data)

replace_na(.data, ..., replace = 0)

random_na(.data, prop)
}
\arguments{
\item{.data}{A data frame or tibble}

\item{verbose}{Logical argument. If \code{TRUE} (default) shows in console
the rows or columns deleted.}

\item{...}{Variables to replace \code{NAs}. If \code{...} is null then all
variables with \code{NA} will be replaced. It must be a single variable
name or a comma-separated list of unquoted variables names. Select helpers
are also allowed.}

\item{replace}{The value used for replacement. Defaults to \code{0}. Use
\code{replace = "colmeans"} to replace missing values with colum means.}

\item{prop}{The proportion (percentage) of \code{NA} values to generate in \code{.data}.}
}
\value{
A data frame with rows or columns with \code{NA} values deleted.
}
\description{
\itemize{
\item \code{has_na()}: Check for \code{NA} values in the data and return a logical value.
\item \code{random_na()}: Generate random \code{NA} values in a two-way table
based on a desired proportion.
\item \code{remove_cols_na()}: Remove columns with \code{NA} values.
\item \code{remove_rows_na()}: Remove rows with \code{NA} values.
\item \code{select_cols_na()}: Select columns with \code{NA} values.
\item \code{select_rows_na()}: Select rows with \code{NA} values.
\item \code{replace_na()} Replace missing values
}
}
\examples{
\donttest{
library(metan)
data_with_na <- data_g
data_with_na[c(1, 5, 10), c(3:5, 10:15)] <- NA
data_with_na
has_na(data_with_na)
remove_cols_na(data_with_na)
remove_rows_na(data_with_na)
select_cols_na(data_with_na)
select_rows_na(data_with_na)
replace_na(data_with_na)
}
}
