% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wsmp.R
\name{plot.wsmp}
\alias{plot.wsmp}
\title{Plot heat maps with genotype ranking}
\usage{
\method{plot}{wsmp}(x, var = 1, type = 1, y.lab = NULL, x.lab = NULL, size.lab = 12, ...)
}
\arguments{
\item{x}{The object returned by the function \code{wsmp}.}

\item{var}{The variable to plot. Defaults to \code{var = 1} the first
variable of \code{x}.}

\item{type}{\code{1 = Heat map Ranks}: this graphic shows the genotype
ranking considering the WAASB index estimated with different numbers of
Principal Components; \code{2 = Heat map WAASY-GY ratio}: this graphic
shows the genotype ranking considering the different combinations in the
WAASB/GY ratio.}

\item{y.lab}{The label of y axis. Default is 'Genotypes'.}

\item{x.lab}{The label of x axis. Default is 'Number of axes'.}

\item{size.lab}{The size of the}

\item{...}{Currently not used.}
}
\value{
An object of class \code{gg}.
}
\description{
Plot heat maps with genotype ranking in two ways.
}
\details{
The first type of heatmap shows the genotype ranking depending on the number
of principal component axis used for estimating the WAASB index. The second type of heatmap shows the
genotype ranking depending on the WAASB/GY ratio. The ranks obtained with a
ratio of 100/0 considers exclusively the stability for the genotype ranking.
On the other hand, a ratio of 0/100 considers exclusively the productivity
for the genotype ranking.  Four clusters of genotypes are shown by label colors (red) unproductive and
unstable genotypes; (blue) productive, but unstable genotypes; (black) stable, but
unproductive genotypes; and (green), productive and stable genotypes.
}
\examples{
\donttest{
library(metan)
model <- waasb(data_ge, ENV, GEN, REP, GY) \%>\%
         wsmp()
p1 <- plot(model)
p2 <- plot(model, type = 2)
arrange_ggplot(p1, p2, ncol = 1)
}

}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
