% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{utils_wd}
\alias{utils_wd}
\alias{set_wd_here}
\alias{get_wd_here}
\alias{open_wd_here}
\alias{open_wd}
\title{Set and get the Working Directory quicky}
\usage{
set_wd_here(path = NULL)

get_wd_here(path = NULL)

open_wd_here(path = get_wd_here())

open_wd(path = getwd())
}
\arguments{
\item{path}{Path components below the project root. Defaults to \code{NULL}. This means that
the directory will be set to the path of the file. If the path doesn't exist, the
user will be asked if he wants to create such a folder.}
}
\value{
\itemize{
\item \code{\link[=get_wd_here]{get_wd_here()}} returns a full-path directory name.
\item \code{\link[=get_wd_here]{get_wd_here()}} returns a message showing the current working directory.
\item \code{\link[=open_wd_here]{open_wd_here()}} Opens the File Explorer of the path returned by \code{get_wd_here()}.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
\itemize{
\item \code{\link[=get_wd_here]{get_wd_here()}} gets the working directory to the path of the current script.
\item \code{\link[=set_wd_here]{set_wd_here()}} sets the working directory to the path of the current script.
\item \code{\link[=open_wd_here]{open_wd_here()}} Open the File Explorer at the directory path of the current script.
\item \code{\link[=open_wd]{open_wd()}} Open the File Explorer at the current working directory.
}
}
\examples{

\dontrun{
get_wd_here()
set_wd_here()
open_wd_here()
}
}
