% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mtmps.R
\name{print.mtmps}
\alias{print.mtmps}
\title{Print an object of class mtmps}
\usage{
\method{print}{mtmps}(x, export = FALSE, file.name = NULL, digits = 4, ...)
}
\arguments{
\item{x}{An object of class \code{mtmps}.}

\item{export}{A logical argument. If \code{TRUE|T}, a *.txt file is exported
to the working directory}

\item{file.name}{The name of the file if \code{export = TRUE}}

\item{digits}{The significant digits to be shown.}

\item{...}{Options used by the tibble package to format the output. See
\code{\link[tibble:formatting]{tibble::print()}} for more details.}
}
\description{
Print a \code{mtmps} object in two ways. By default, the results are shown in
the R console. The results can also be exported to the directory.
}
\examples{
\donttest{
library(metan)
model <-
mps(data_ge,
    env = ENV,
    gen = GEN,
    rep = REP,
    resp = everything())
selection <- mtmps(model)
print(selection)
}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
