% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtb.R
\name{gtb}
\alias{gtb}
\title{Genotype by trait biplot}
\usage{
gtb(.data, gen, resp, centering = "trait", scaling = "sd", svp = "trait")
}
\arguments{
\item{.data}{The dataset containing the columns related to Genotypes and the
response variable(s).}

\item{gen}{The name of the column that contains the levels of the genotypes.}

\item{resp}{The response variables, i.e., \code{resp = c(var1, var2, var3)}.
Select helpers can also be used.}

\item{centering}{The centering method. Must be one of the \code{'none | 0'},
for no centering; \code{'global | 1'}, for global centered (T+G+GT);
\code{'trait | 2'} (default), for trait-centered (G+GT); or \code{'double | 3'}, for double centred (GT). A biplot cannot be produced with models
produced without centering.}

\item{scaling}{The scaling method. Must be one of the \code{'none | 0'}, for
no scaling; or \code{'sd | 1'} (default), where each value is divided by
the standard deviation of its corresponding trait (column). This will put
all traits roughly he same rang of values.}

\item{svp}{The method for singular value partitioning. Must be one of the
\code{'genotype | 1'}, (The singular value is entirely partitioned into the
genotype eigenvectors, also called row metric preserving); \code{'trait | 2'}, default, (The singular value is entirely partitioned into the trait
eigenvectors, also called column metric preserving); or \code{'symmetrical | 3'} (The singular value is symmetrically partitioned into the genotype
and the trait eigenvectors This SVP is most often used in AMMI analysis and
other biplot analysis, but it is not ideal for visualizing either the
relationship among genotypes or that among the traits).}
}
\value{
The function returns a list of class \code{gge} that is compatible with the function \code{plot()} used in \code{\link[=gge]{gge()}}.
\itemize{
\item \strong{coordgen} The coordinates for genotypes for all components.
\item \strong{coordenv} The coordinates for traits for all components.
\item \strong{eigenvalues} The vector of eigenvalues.
\item \strong{totalvar} The overall variance.
\item \strong{labelgen} The name of the genotypes.
\item \strong{labelenv} The names of the traits.
\item \strong{labelaxes} The axes labels.
\item \strong{gt_mat} The data used to produce the model (scaled and centered).
\item \strong{centering} The centering method.
\item \strong{scaling} The scaling method.
\item \strong{svp} The singular value partitioning method.
\item \strong{d} The factor used to generate in which the ranges of genotypes
and traits are comparable when singular value partitioning is set to
'genotype' or 'trait'.
\item \strong{grand_mean} The grand mean of the trial.
\item \strong{mean_gen} A vector with the means of the genotypes.
\item \strong{mean_env} A vector with the means of the traits.
\item \strong{scale_var} The scaling vector when the scaling method is \code{'sd'}.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Produces a genotype-by-trait biplot model. From a genotype by environment by
trait three-way table, genotype-by-trait tables in any single environment,
across all environments, or across a subset of the environments can be
generated and visually studied using biplots. The model for biplot analysis
of genotype by trait data is the singular value decomposition of
trait-standardized two-way table.
}
\examples{
\donttest{
library(metan)
# GT biplot for all numeric variables
mod <- gtb(data_ge2, GEN, resp = contains("E"))
plot(mod)

}
}
\references{
Yan, W., and M.S. Kang. 2003. GGE biplot analysis: a graphical tool for breeders,
geneticists, and agronomists. CRC Press.
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
