% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alphadat.R
\docType{data}
\name{alphadat}
\alias{alphadat}
\title{Alpha diversity data.}
\format{A list of 4 dataframes for four indexes: Chao1, Observed_species, PD_whole_tree, Shannon.}
\source{
\href{https://gordonlab.wustl.edu/Subramanian_6_14/Nature_2014_Processed_16S_rRNA_datasets.html}{Gordon Lab}
}
\usage{
data(alphadat)
}
\description{
Alpha diversity data from alpha_rarefaction output from QIIME.
}
\examples{
data(alphadat)
# Load covariate data
data(covar.rm)
covar.rm$sampleid<-tolower(covar.rm$sampleid)
#comparison of standardized alpha diversity indexes between genders adjusting for
#breastfeeding and infant age at sample collection in infants <=6 months of age
alphacom<-alpha.compare(datlist=alphadat,depth=3,mapfile=covar.rm,
mapsampleid="sampleid", comvar="gender",adjustvar=c("age.sample","bf"),
longitudinal="yes", age.limit=6,standardize=TRUE)
alphacom$alphasum[,1:5]
}
\references{
Subramanian et al. Nature. 2014 Jun 19; 510(7505): 417–421.
(\href{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC4189846/}{PubMed})
}
\keyword{datasets}
