% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FEmrt_main.R
\name{FEmrt}
\alias{FEmrt}
\title{Fixed effect meta-tree}
\usage{
FEmrt(formula, data, vi, subset, c = 1, control = rpart.control(xval =
  10, minbucket = 3, minsplit = 6, cp = 1e-04), ...)
}
\arguments{
\item{formula}{A formula, with an outcome variable (usually the effect size) and the potential moderator variables but no interaction terms.}

\item{data}{A data frame of a meta-analytic data set, including the study effect sizes, sampling variance, and the potential moderators.}

\item{vi}{sampling variance of the effect size.}

\item{subset}{optional expression that selects only a subset of the rows of the data.}

\item{c}{A non-negative scalar.The pruning parameter to prune the initial tree by the "c*standard-error" rule.}

\item{control}{the control object (similar to rpart.control from the rpart package) that is used in the tree algorithm}

\item{...}{Additional arguments passed to the tree growing algorithm based on \pkg{rpart}.}
}
\value{
\strong{If (a) moderator effect(s) is(are) detected, the function will return a \code{FEmrt} object including the following components:}

tree: The pruned tree that represents the moderator effect(s) and interaction effect(s) between them.

n: The number of the studies in each subgroup

Qb: The between-subgroups Q-statistic

df: The degree of freedoms of the between-subgroups Q test

pval.Qb: The p-value of the between-subgroups Q test

Qw: The within-subgroup Q-statistic in each subgroup

g: The subgroup summary effect size, based on Hedges'g

se: The standard error of the subgroup summary effect size

zval: The test statistic of the subgroup summary effect size

pval: The p-value for the test statistics of the subgroup summary effect size

ci.lb: The lower bound of the confidence interval

ci.ub: The upper bound of the confidence interval

call: The matched call

\strong{If no moderator effect is detected, the function will return a \code{FEmrt} object including the following components:}

n: The total number of the studies

Q: The Q-statistic of the heterogeneity test

df: The degrees of freedom of the heterogeneity test

pval.Q: The p-value of the heterogeneity test

g: The summary effect size for all studies

se: The standard error of the summary effect size

zval: The test statistic of the summary effect size

pval: The p-value of the test statistic of the summary effect size

ci.lb: The lower bound of the confidence interval for the summary effect size

ci.ub: The upper bound of the confidence interval for the summary effect size

call: The matched call
}
\description{
A function to fit fixed effect meta-trees to meta-analytic data.
The model is assuming a fixed effect within subgroups and between subgroups.
The tree growing process is equivalent to the approach described in Li et al. (2017) using fixed effect weights in the function \pkg{rpart()} developed by Therneau, Atkinson & Ripley (2014).
}
\examples{
data(dat.BCT2009)
FEtree <- FEmrt(g ~ T1 + T2+ T4 + T25, vi = vi, data = dat.BCT2009, c = 0)
print(FEtree)
summary(FEtree)
plot(FEtree)
}
\references{
Dusseldorp, E., van Genugten, L., van Buuren, S., Verheijden, M. W., & van Empelen, P. (2014). Combinations of techniques that effectively change health behavior: Evidence from meta-cart analysis.  \emph{Health Psychology, 33(12)}, 1530-1540. doi:
     10.1037/hea0000018.

Li, X., Dusseldorp, E., & Meulman, J. J. (2017). Meta-CART: A tool to identify interactions between moderators in meta-analysis. \emph{ British Journal of Mathematical and Statistical Psychology, 70(1)}, 118-136. doi: 10.1111/bmsp.12088.

Therneau, T., Atkinson, B., & Ripley, B. (2014) rpart: Recursive partitioning and regression trees. R package version, 4-1.
}
\seealso{
\code{\link{summary.FEmrt}}, \code{\link{plot.FEmrt}}, \code{\link{rpart}},\code{\link{rpart.control}}
}
