% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weightReacts.R
\name{rescueDist}
\alias{rescueDist}
\title{Compute distances of rescue reactions}
\usage{
rescueDist(
  model,
  mc.cores = 1,
  gene.num = 1,
  draw.num = 1000,
  tol = SYBIL_SETTINGS("TOLERANCE")
)
}
\arguments{
\item{model}{An object of class \code{modelorg}.}

\item{mc.cores}{The number of cores to use (at least 1), i.e. at most how many child processes will be run simultaneously. Default: 1.}

\item{gene.num}{The number of genes to remove. If 1, \code{oneGeneDel} will be performed and draw.num will be ignored. Default: 1.}

\item{draw.num}{The number of random draws. Default: 1000. It is ignored when gene.nume = 1.}

\item{tol}{The maximum value to be considered null. Default: \code{SYBIL_SETTINGS("TOLERANCE")}.}
}
\value{
An object of class \code{dist}, containing distances between rescue reactions in the given model.
}
\description{
The function rescueDist computes the distances (similarities) between rescue reactions.
}
\keyword{internal}
