% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_variability_from_dispersion.R
\name{es_variab_from_means_sd}
\alias{es_variab_from_means_sd}
\title{Convert means and/or standard deviations of two independent groups into two effect measures (VR/CVR)}
\usage{
es_variab_from_means_sd(
  mean_exp,
  mean_nexp,
  mean_sd_exp,
  mean_sd_nexp,
  n_exp,
  n_nexp,
  reverse_means_variability
)
}
\arguments{
\item{mean_exp}{mean of participants in the experimental/exposed group.}

\item{mean_nexp}{mean of participants in the non-experimental/non-exposed group.}

\item{mean_sd_exp}{standard deviation of participants in the experimental/exposed group.}

\item{mean_sd_nexp}{standard deviation of participants in the non-experimental/non-exposed group.}

\item{n_exp}{number of participants in the experimental/exposed group.}

\item{n_nexp}{number of participants in the non-experimental/non-exposed group.}

\item{reverse_means_variability}{a logical value indicating whether the direction of the generated effect sizes should be flipped.}
}
\value{
This function estimates VR and CVR

\tabular{ll}{
\code{natural effect size measure} \tab VR + CVR\cr
\tab \cr
\code{converted effect size measure} \tab No conversion performed\cr
\tab \cr
\code{required input data} \tab See 'Section 23. User's input (crude)'\cr
\tab https://metaconvert.org/html/input.html\cr
\tab \cr
}
}
\description{
Convert means and/or standard deviations of two independent groups into two effect measures (VR/CVR)
}
\details{
This function converts the means and standard deviations of two independent groups into a log variability ratio (VR) and a log coefficient of variation ratio (CVR).

The formulas used to obtain the log VR are (formulas 5 and 15, Senior et al. 2020):
\deqn{logvr = log(\frac{mean\_sd\_exp}{mean\_sd\_nexp}) + \frac{1}{2 * (n\_exp - 1)} - \frac{1}{2 * (n\_nexp - 1)}}
\deqn{logvr\_se = \sqrt{\frac{1}{2} * (\frac{n\_nexp}{(n\_nexp - 1)^2} + \frac{n\_exp}{(n\_exp - 1)^2})}}
\deqn{logvr\_ci\_lo = logvr - qnorm(.975) * logvr\_se}
\deqn{logvr\_ci\_up = logvr + qnorm(.975) * logvr\_se}

The formulas used to obtain the log CVR are (formulas 6 and 16, Senior et al. 2020):
\deqn{cvt = mean\_sd\_exp / mean\_exp}
\deqn{cvc = mean\_sd\_nexp / mean\_nexp}
\deqn{logcvr = log(\frac{cvt}{cvc}) + \frac{1}{2} * (\frac{1}{n\_exp - 1} - \frac{1}{n\_nexp - 1}) + \frac{1}{2} * (\frac{mean\_sd\_nexp^2}{n\_nexp * mean\_nexp^2} - \frac{mean\_sd\_exp^2}{n\_exp * mean\_exp^2})}
\deqn{vt\_exp = \frac{mean\_sd\_exp^2}{n\_exp * mean\_exp^2} + \frac{mean\_sd\_exp^4}{2 * n\_exp^2 * mean\_exp^4} + \frac{n\_exp}{(n\_exp - 1)^2}}
\deqn{vt\_nexp = \frac{mean\_sd\_nexp^2}{n\_nexp * mean\_nexp^2} + \frac{mean\_sd\_nexp^4}{2 * n\_nexp^2 * mean\_nexp^4} + \frac{n\_nexp}{(n\_nexp - 1)^2}}
\deqn{logcvr\_se = \sqrt{vt\_exp + vt\_nexp}}
\deqn{logcvr\_ci\_lo = logcvr - qnorm(.975) * logcvr\_se}
\deqn{logcvr\_ci\_up = logcvr + qnorm(.975) * logcvr\_se}
}
\examples{
es_variab_from_means_sd(
  n_exp = 55, n_nexp = 55,
  mean_exp = 2.3, mean_sd_exp = 1.2,
  mean_nexp = 1.9, mean_sd_nexp = 0.9
)
}
\references{
Senior, A. M., Viechtbauer, W., & Nakagawa, S. (2020). Revisiting and expanding the meta-analysis of variation: The log coefficient of variation ratio. Research Synthesis Methods, 11(4), 553-567. https://doi.org/10.1002/jrsm.1423
}
