% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cidprop.R
\name{cidprop.meta}
\alias{cidprop.meta}
\alias{cidprop}
\alias{print.cidprop}
\title{Calculate expected proportion of comparable studies with clinically important
benefit or harm}
\usage{
\method{cidprop}{meta}(
  x,
  cid = NULL,
  cid.below.null = NULL,
  cid.above.null = NULL,
  label.cid = "",
  label.cid.below.null = NULL,
  label.cid.above.null = NULL,
  small.values = "desirable",
  ...
)

cidprop(x, ...)

\method{print}{cidprop}(
  x,
  digits.cid = gs("digits.cid"),
  digits.percent = 1,
  big.mark = gs("big.mark"),
  details.methods = gs("details"),
  ...
)
}
\arguments{
\item{x}{An object of class \code{meta}.}

\item{cid}{A numeric value or vector specifying clinically important
differences (CID) / decision thresholds used to calculate expected
proportions of clinically important benefit or harm (see Details).}

\item{cid.below.null}{A numeric value or vector specifying CID limits below
the null effect (see Details).}

\item{cid.above.null}{A numeric value or vector specifying CID limits above
the null effect (see Details).}

\item{label.cid}{A character string or vector specifying labels for
clinically important differences. Must be of same length as argument
\code{cid}.}

\item{label.cid.below.null}{A character string or vector specifying labels
for clinically important differences below the null effect. Must be of
same length as argument \code{cid.below.null} (or \code{cid}).}

\item{label.cid.above.null}{A character string or vector specifying labels
for clinically important differences above the null effect. Must be of
same length as argument \code{cid.above.null} (or \code{cid}).}

\item{small.values}{A character string specifying whether small
treatment effects indicate a beneficial (\code{"desirable"}) or
harmful (\code{"undesirable"}), can be abbreviated.}

\item{\dots}{Additional arguments (ignored)}

\item{digits.cid}{Minimal number of significant digits for
CIDs / decision thresholds, see \code{print.default}.}

\item{digits.percent}{Minimal number of significant digits for
expected proportions, printed as percentages, see \code{print.default}.}

\item{big.mark}{A character used as thousands separator.}

\item{details.methods}{A logical specifying whether details on
statistical methods should be printed.}
}
\value{
A list with elements
\item{prop.cid.below.null}{Expected proportion of comparable studies below
  lower CID(s)}
\item{prop.cid.above.null}{Expected proportion of comparable studies above
  upper CID(s)}
\item{prop.within.cid}{Expected proportion of comparable studies between
  lower and upper CID(s)}
\item{cid, cid.below.null, cid.above.null, small.values, x}{As defined
  above}
\item{label.cid, label.cid.below.null, label.cid.above.null}{As defined
  above}
}
\description{
Calculate expected proportion of comparable studies with clinically important
benefit or harm which is derived from the prediction interval.
}
\details{
Expected proportions of comparable studies with clinically important
benefit or harm are derived from the prediction interval in
the meta-analysis.

Clinically important benefit or harm can be defined using either argument
\code{cid} or \code{cid.below.null} and \code{cid.above.null}.
Input for the later arguments will be ignored if argument \code{cid} was
specified. In this case, the values of \code{cid.below.null} and
\code{cid.above.null} will be equal to
\itemize{
\item \code{cid} and \code{1 / cid} for ratio measures,
\item \code{cid} and \code{-cid} for difference measures.
}

Thresholds based on argument \code{cid} will always be symmetric. Asymmetric
thresholds can be defined using arguments \code{cid.below.null} and
\code{cid.above.null}.
}
\examples{
oldset <- settings.meta(digits.cid = 0)

m <- metagen(1:10 - 3, 1:10, sm = "MD")
#
pp1 <- cidprop(m, cid = 2)
pp1
#
pp2 <- cidprop(m, cid.below = 0.5, cid.above = 2)
pp2
#
pp3 <- cidprop(m, cid.below = 0.5, cid.above = 2, small.values = "u")
pp3

pp4 <- cidprop(m, cid = 1:2, label.cid = c("moderate", "large"))
pp4
#
pp5 <- cidprop(m, cid.below = -1.5, cid.above = 1:2,
  label.cid.below = "large", label.cid.above = c("moderate", "large"))
pp5

settings.meta(oldset)

}
\seealso{
\code{\link{plot.cidprop}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
