% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_label_contour.R, R/geom_text_contour.R,
%   R/stat_contour2.r
\docType{data}
\name{geom_label_contour}
\alias{geom_label_contour}
\alias{GeomLabelContour}
\alias{geom_text_contour}
\alias{GeomTextContour}
\alias{StatTextContour}
\title{Label contours}
\usage{
geom_label_contour(
  mapping = NULL,
  data = NULL,
  stat = "text_contour",
  position = "identity",
  ...,
  min.size = 5,
  skip = 0,
  parse = FALSE,
  nudge_x = 0,
  nudge_y = 0,
  label.padding = grid::unit(0.25, "lines"),
  label.r = grid::unit(0.15, "lines"),
  label.size = 0.25,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_text_contour(
  mapping = NULL,
  data = NULL,
  stat = "text_contour",
  position = "identity",
  ...,
  min.size = 5,
  skip = 1,
  rotate = TRUE,
  label.placement = label_placement_flattest(),
  parse = FALSE,
  nudge_x = 0,
  nudge_y = 0,
  stroke = 0,
  stroke.color = "white",
  check_overlap = FALSE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function. Cannot be jointy specified with
\code{nudge_x} or \code{nudge_y}.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{min.size}{minimum number of points for a contour to be labelled.}

\item{skip}{number of contours to skip}

\item{parse}{If \code{TRUE}, the labels will be parsed into expressions and
displayed as described in \code{?plotmath}.}

\item{nudge_x}{Horizontal and vertical adjustment to nudge labels by.
Useful for offsetting text from points, particularly on discrete scales.
Cannot be jointly specified with \code{position}.}

\item{nudge_y}{Horizontal and vertical adjustment to nudge labels by.
Useful for offsetting text from points, particularly on discrete scales.
Cannot be jointly specified with \code{position}.}

\item{label.padding}{Amount of padding around label. Defaults to 0.25 lines.}

\item{label.r}{Radius of rounded corners. Defaults to 0.15 lines.}

\item{label.size}{Size of label border, in mm.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{rotate}{logical indicating whether to rotate text following the contour.}

\item{label.placement}{A function for placing labels (see \code{label_placement_flattest()}).}

\item{stroke}{numerical indicating width of stroke relative to the size of
the text. Ignored if less than zero.}

\item{stroke.color}{any valid colour.}

\item{check_overlap}{If \code{TRUE}, text that overlaps previous text in the
same layer will not be plotted. \code{check_overlap} happens at draw time and in
the order of the data. Therefore data should be arranged by the label
column before calling \code{geom_label()} or \code{geom_text()}.}
}
\description{
Draws labels on contours built with \link[ggplot2:geom_contour]{ggplot2::stat_contour}.
}
\details{
Is best used with a previous call to \link[ggplot2:geom_contour]{ggplot2::stat_contour} with the same
parameters (e.g. the same \code{binwidth}, \code{breaks}, or \code{bins}).
Note that while \code{geom_text_contour()} can angle itself to follow the contour,
this is not the case with \code{geom_label_contour()}.
}
\section{Aesthetics}{

\code{geom_text_contour} understands the following aesthetics (required aesthetics are in bold):

\itemize{
\item \strong{x}
\item \strong{y}
\item \strong{label}
\item \code{alpha}
\item \code{angle}
\item \code{colour}
\item \code{family}
\item \code{fontface}
\item \code{group}
\item \code{hjust}
\item \code{lineheight}
\item \code{size}
\item \code{vjust}
}
}

\examples{
library(ggplot2)
v <- reshape2::melt(volcano)
g <- ggplot(v, aes(Var1, Var2)) +
       geom_contour(aes(z = value))
g + geom_text_contour(aes(z = value))

g + geom_text_contour(aes(z = value), stroke = 0.2)

g + geom_text_contour(aes(z = value), rotate = FALSE)

g + geom_text_contour(aes(z = value),
                      label.placement = label_placement_random())

g + geom_text_contour(aes(z = value),
                      label.placement = label_placement_n(3))


g + geom_text_contour(aes(z = value),
                      label.placement = label_placement_flattest())

g + geom_text_contour(aes(z = value),
                      label.placement = label_placement_flattest(ref_angle = 90))

}
\seealso{
Other ggplot2 helpers: 
\code{\link{DivideTimeseries}()},
\code{\link{MakeBreaks}()},
\code{\link{WrapCircular}()},
\code{\link{geom_arrow}()},
\code{\link{geom_contour2}()},
\code{\link{geom_contour_fill}()},
\code{\link{geom_relief}()},
\code{\link{geom_streamline}()},
\code{\link{guide_colourstrip}()},
\code{\link{map_labels}},
\code{\link{reverselog_trans}()},
\code{\link{scale_divergent}},
\code{\link{scale_longitude}},
\code{\link{stat_na}()},
\code{\link{stat_subset}()}
}
\concept{ggplot2 helpers}
\keyword{datasets}
