% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Interpolate.R
\name{Interpolate}
\alias{Interpolate}
\title{Bilinear interpolation}
\usage{
Interpolate(formula, x.out, y.out, data = NULL, grid = TRUE, path = FALSE)
}
\arguments{
\item{formula}{a formula indicating dependent and independent variables (see Details)}

\item{x.out, y.out}{x and y values where to interpolate (see Details)}

\item{data}{optional data.frame with the data}

\item{grid}{logical indicating if x.out and y.out define a regular grid.}

\item{path}{a logical or character indicating if the x.out and y.out define a
path. If character, it will be the name of the column returning the order of
said path.}
}
\value{
A data.frame with interpolated values and locations
}
\description{
Interpolates values using bilinear interpolation.
}
\details{
\code{formula} must be of the form VAR1 | VAR2 ~ X + Y where VAR1, VAR2, etc...
are the names of the variables to interpolate and X and Y the names of the
x and y values, respectively. It is also possible to pass only values of x,
in which case, regular linear interpolation is performed and y.out, if exists,
is ignored with a warning.

If \code{grid = TRUE}, \code{x.out} and \code{y.out} must define the values of a regular
grid. If \code{grid = FALSE}, they define the locations where to interpolate.
Both \code{grid} and \code{path} cannot be set to \code{TRUE} and the value of \code{path} takes
precedence.

\code{x.out} can be a list, in which case, the first two elements will be interpreted
as the x and y values where to interpolate and it can also have a \code{path} element
that will be used in place of the \code{path} argument. This helps when creating a
path with \link{as.path} (see Examples)
}
\examples{
library(data.table)
data(geopotential)
geopotential <- geopotential[date == date[1]]
# new grid
x.out <- seq(0, 360, by = 10)
y.out <- seq(-90, 0, by = 10)

# Interpolate values to a new grid
interpolated <- geopotential[, Interpolate(gh ~ lon + lat, x.out, y.out)]

# Add values to an existing grid
geopotential[, gh.new := Interpolate(gh ~ lon + lat, lon, lat,
                                     data = interpolated, grid = FALSE)$gh]

# Interpolate multiple values
geopotential[, c("u", "v") := GeostrophicWind(gh, lon, lat)]
interpolated <- geopotential[, Interpolate(u | v ~ lon + lat, x.out, y.out)]

# Interpolate values following a path
lats <- c(-34, -54, -30)   # start and end latitudes
lons <- c(302, 290, 180)   # start and end longituded
path <- geopotential[, Interpolate(gh ~ lon + lat, as.path(lons, lats))]

}
