% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swap.r
\docType{methods}
\name{Swaps}
\alias{Swaps}
\alias{swap.names}
\alias{swap.names,memuse-method}
\alias{swap.prefix}
\alias{swap.prefix,memuse-method}
\alias{swap.unit}
\alias{swap.unit,memuse-method}
\title{Swaps}
\usage{
swap.prefix(x)

\S4method{swap.prefix}{memuse}(x)

swap.names(x)

\S4method{swap.names}{memuse}(x)

swap.unit(x, unit, precedence = .PRECEDENCE)

\S4method{swap.unit}{memuse}(x, unit)
}
\arguments{
\item{x}{memuse object}

\item{unit}{new unit for the \code{memuse} object after the swap occurs}

\item{precedence}{Currently does nothing.}
}
\value{
Returns a \code{memuse} class object.
}
\description{
Methods for swapping between different memuse formats.
}
\details{
These methods allow simple (coherent) swaps between the different
\code{memuse} formats.

\code{swap.unit()} will switch an object to another, supplied unit.  If the
unit is from another prefix, then the prefix too will change.  In this case,
the size will change appropriately.

\code{swap.prefix()} will change an object from one unit.prefix to the
other. In this case, the size will change appropriately.

\code{swap.names} will change from short to long, or long to short printing.
The size and prefix of the object are unchanged.
}
\examples{
\dontrun{
x <- mu(1e6)

x
swap.prefix(x)
swap.names(x)
swap.unit(x, "bytes")
}

}
\seealso{
\code{ \link{Constructor} \link{memuse-class} }
}
\keyword{Methods}

