% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memsurveillance.animated.R
\name{memsurveillance.animated}
\alias{memsurveillance.animated}
\title{Creates the animated  graph of the surveillance of the current season}
\usage{
memsurveillance.animated(i.current, i.epidemic.thresholds = NA,
  i.intensity.thresholds = NA, i.output = ".",
  i.animated.graph.file = T, i.animated.graph.file.name = "animated",
  i.fps = 2, i.loop = 0, i.remove = T, ...)
}
\arguments{
\item{i.current}{Current season weekly rates.}

\item{i.epidemic.thresholds}{Pre and post epidemic threholds.}

\item{i.intensity.thresholds}{Intensity thresholds.}

\item{i.output}{Directory where graph is saved.}

\item{i.animated.graph.file}{If a animated gif should be produced, or just the intermediate graphics}

\item{i.animated.graph.file.name}{Name of the animated graph.}

\item{i.fps}{Number of frames per second of the animated gif.}

\item{i.loop}{Number of loops for the animated dif, 0 for Infinite.}

\item{i.remove}{Remove partial graphs.}

\item{...}{Additional parameters parsed to memsurveillance.}
}
\value{
\code{memsurveillance.animated} writes a gif graph of the surveillance of this season.
}
\description{
Function \code{memsurveillance.animated} creates an animated surveillance graph for the current season.
}
\details{
Input data must be the current season and an object of class \code{mem}. The output
graph contains the weekly rates series along with the epidemic and intensity threshols
located at the exact situation where the epidemic started. If there is no epidemic yet,
only the epidemic threshold is placed.

See \link{memsurveillance} for more details
}
\examples{
# Castilla y Leon Influenza Rates data
data(flucyl)
# Data of the last season
cur<-flucyl[8]
# The model
epi<-memmodel(flucyl[1:7])
# Epidemic thresholds
e.thr<-epi$epidemic.thresholds
# Intensity threhsolds
i.thr<-epi$intensity.thresholds
# Set the working directory to whererever you want to store the graph file
setwd(".")
m1<-memsurveillance.animated(cur, i.animated.graph.file.name="Animated",
i.epidemic.thresholds = e.thr,i.intensity.thresholds = i.thr, i.pos.epidemic = TRUE,
i.animated.graph.file = FALSE)

}
\references{
Vega T, Lozano JE, Ortiz de Lejarazu R, Gutierrez Perez M. Modelling influenza epidemic - can we
detect the beginning and predict the intensity and duration? Int Congr Ser. 2004 Jun;1263:281-3.

Vega T, Lozano JE, Meerhoff T, Snacken R, Mott J, Ortiz de Lejarazu R, et al. Influenza surveillance
in Europe: establishing epidemic thresholds by the moving epidemic method. Influenza Other Respir
Viruses. 2013 Jul;7(4):546-58. DOI:10.1111/j.1750-2659.2012.00422.x.

Vega T, Lozano JE, Meerhoff T, Snacken R, Beaute J, Jorgensen P, et al. Influenza surveillance in
Europe: comparing intensity levels calculated using the moving epidemic method. Influenza Other
Respir Viruses. 2015 Sep;9(5):234-46. DOI:10.1111/irv.12330.

Lozano JE. lozalojo/mem: Second release of the MEM R library. Zenodo [Internet]. [cited 2017 Feb 1];
Available from: \url{https://zenodo.org/record/165983}. DOI:10.5281/zenodo.165983
}
\author{
Jose E. Lozano \email{lozalojo@gmail.com}
}
\keyword{influenza}
