% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edge_tax_comp.R
\name{edge_tax_comp}
\alias{edge_tax_comp}
\title{Taxonomic sum of linked nodes in edges across networks}
\usage{
edge_tax_comp(network_list, taxrank = "Phylum", label = "+", rel = TRUE)
}
\arguments{
\item{network_list}{a list with multiple networks; all the networks should be trans_network object created from \code{\link{trans_network}} class of \code{microeco} package.}

\item{taxrank}{default "Phylum"; Which taxonomic level is used for the sum of nodes in edges.}

\item{label}{default "+"; "+" or "-" or \code{c("+", "-")}; the edge label used for the selection of edges for the sum.}

\item{rel}{default \code{TRUE}; \code{TRUE} represents using ratio, the denominator is the number of selected edges; 
\code{FALSE} represents the absolute number of the sum of edges.}
}
\value{
\code{data.frame}
}
\description{
Taxonomic sum of linked nodes in edges across networks.
}
\examples{
data(soil_amp_network)
test <- edge_tax_comp(soil_amp_network)
# test is a microtable object

}
