% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdgc.R
\name{get_mdgc_log_ml}
\alias{get_mdgc_log_ml}
\alias{get_mdgc_log_ml.mdgc}
\alias{get_mdgc_log_ml.data.frame}
\alias{get_mdgc_log_ml.default}
\title{Get Pointer to C++ Object to Approximate the Log Marginal Likelihood}
\usage{
get_mdgc_log_ml(object, ...)

\method{get_mdgc_log_ml}{mdgc}(object, ...)

\method{get_mdgc_log_ml}{data.frame}(object, ...)

\method{get_mdgc_log_ml}{default}(
  object,
  lower,
  upper,
  code,
  multinomial,
  idx_non_zero_mean,
  ...
)
}
\arguments{
\item{object}{mdgc object from \code{\link{get_mdgc}} or a
\code{\link{data.frame}} to pass to \code{\link{get_mdgc}}. Ignored by
the default method.}

\item{...}{used to pass arguments to S3 methods.}

\item{lower}{[# variables]x[# observations] matrix with lower bounds
for each variable on the normal scale.}

\item{upper}{[# variables]x[# observations] matrix with upper bounds
for each variable on the normal scale.}

\item{code}{[# variables]x[# observations] matrix integer code for the
each variable on the normal scale. Zero implies an observed value (the
value in \code{upper}), one implies a missing value, and two implies an
interval.}

\item{multinomial}{\code{\link{list}} where each element is
3x[# multinomial variables] \code{\link{matrix}} with
multinomial outcomes. The first index is the outcome as an integer code,
the second index is the number of categories, and the third index is the
index of each multinomial variable (this is zero-based).}

\item{idx_non_zero_mean}{indices for non-zero mean variables. Indices
should be sorted.}
}
\value{
A \code{Rcpp::XPtr} to pass to e.g. \code{\link{mdgc_log_ml}}.
}
\description{
Creates a C++ object which is needed to approximate the log marginal
likelihood. The object cannot be saved.
}
\details{
Indices are zero-based except the outcome index for multinomial
variables.

\code{idx_non_zero_mean} indices with terms with \code{code} equal to zero
(observed values) are ignored.
}
\examples{
# randomly mask data
set.seed(11)
masked_data <- iris
masked_data[matrix(runif(prod(dim(iris))) < .10, NROW(iris))] <- NA

# use the functions in the package
library(mdgc)
obj <- get_mdgc(masked_data)
ptr <- get_mdgc_log_ml(obj)

}
\seealso{
\code{\link{mdgc_fit}}, \code{\link{mdgc_log_ml}}
}
