/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.dendrogram.figures;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import multidendrograms.definitions.Coordinates;
import multidendrograms.dendrogram.Scaling;
import multidendrograms.dendrogram.eps.EpsUtils;
import multidendrograms.dendrogram.figures.Figure;
import multidendrograms.initial.LogManager;
import multidendrograms.types.DendrogramOrientation;
import multidendrograms.types.PlotType;

public class Line
extends Figure {
    private double length;

    public Line(double d, double d2, double d3) {
        super(d, d2);
        this.length = d3;
    }

    public Line(double d, double d2, double d3, Color color) {
        super(d, d2, color);
        this.length = d3;
    }

    public double getLength() {
        return this.length;
    }

    public void setLength(double d) {
        this.length = d;
    }

    @Override
    public void draw(PlotType plotType, Graphics2D graphics2D) {
        double d = this.getPosReal().getX();
        double d2 = this.getPosReal().getY();
        double d3 = d;
        double d4 = this.length;
        Coordinates<Double> coordinates = new Coordinates<Double>(d, d2);
        Coordinates<Double> coordinates2 = new Coordinates<Double>(d3, d4);
        Scaling scaling = this.getScaling();
        DendrogramOrientation dendrogramOrientation = this.getDendrogramOrientation();
        Coordinates<Double> coordinates3 = scaling.transform(coordinates, dendrogramOrientation);
        Coordinates<Double> coordinates4 = scaling.transform(coordinates2, dendrogramOrientation);
        double d5 = coordinates3.getX();
        double d6 = coordinates3.getY();
        double d7 = coordinates4.getX();
        double d8 = coordinates4.getY();
        Color color = this.getColor();
        if (plotType.equals((Object)PlotType.PANEL)) {
            graphics2D.setColor(color);
            graphics2D.draw(new Line2D.Double(d5, d6, d7, d8));
        } else {
            EpsUtils.writeLine("gsave");
            EpsUtils.writeLine(EpsUtils.setRGBColor((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f));
            if (dendrogramOrientation.equals((Object)DendrogramOrientation.NORTH)) {
                EpsUtils.writeLine(EpsUtils.dLine((float)((double)EpsUtils.xmin + d5), (float)((double)EpsUtils.ymax + d6 - 0.5), (float)((double)EpsUtils.xmin + d7), (float)((double)EpsUtils.ymax + d8 + 0.5)));
            } else if (dendrogramOrientation.equals((Object)DendrogramOrientation.SOUTH)) {
                EpsUtils.writeLine(EpsUtils.dLine((float)((double)EpsUtils.xmin + d5), (float)((double)EpsUtils.ymax + d6 + 0.5), (float)((double)EpsUtils.xmin + d7), (float)((double)EpsUtils.ymax + d8 - 0.5)));
            } else if (dendrogramOrientation.equals((Object)DendrogramOrientation.EAST)) {
                EpsUtils.writeLine(EpsUtils.dLine((float)((double)EpsUtils.xmin + d5 - 0.5), (float)((double)EpsUtils.ymax + d6), (float)((double)EpsUtils.xmin + d7 + 0.5), (float)((double)EpsUtils.ymax + d8)));
            } else if (dendrogramOrientation.equals((Object)DendrogramOrientation.WEST)) {
                EpsUtils.writeLine(EpsUtils.dLine((float)((double)EpsUtils.xmin + d5 + 0.5), (float)((double)EpsUtils.ymax + d6), (float)((double)EpsUtils.xmin + d7 - 0.5), (float)((double)EpsUtils.ymax + d8)));
            }
            EpsUtils.writeLine("grestore");
        }
        LogManager.LOG.finest("Real coord.: x1 = " + d + "    y1 = " + d2 + "    x2 = " + d3 + "    y2 = " + d4);
        LogManager.LOG.finer("draw Line2D: (" + d5 + ", " + d6 + ", " + d7 + ", " + d8 + ")");
    }
}

