% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcares.R
\name{plotResiduals.pcares}
\alias{plotResiduals.pcares}
\title{Residuals plot for PCA results}
\usage{
\method{plotResiduals}{pcares}(obj, ncomp = NULL, main = NULL,
  xlab = NULL, ylab = NULL, show.labels = F, show.limits = T,
  norm = F, xlim = NULL, ylim = NULL, lim.col = c("#333333", "#333333"),
  lim.lwd = c(1, 1), lim.lty = c(2, 3), ...)
}
\arguments{
\item{obj}{object of \code{ldecomp} class.}

\item{ncomp}{what number of components to show the plot for (if NULL, model selected value will be used).}

\item{main}{main title for the plot}

\item{xlab}{label for x axis}

\item{ylab}{label for y axis}

\item{show.labels}{logical, show or not labels for the plot objects}

\item{show.limits}{logical, show or not lines for statistical limits of the residuals}

\item{norm}{logical, show normalized Q vs T2 (\code{norm = T}) values or original ones (\code{norm = F})}

\item{xlim}{limits for x-axis}

\item{ylim}{limits for y-axis}

\item{lim.col}{vector with two values - line color for extreme and outlier borders}

\item{lim.lwd}{vector with two values - line width for extreme and outlier borders}

\item{lim.lty}{vector with two values - line type for extreme and outlier borders}

\item{...}{most of graphical parameters from \code{\link{mdaplot}} function can be used.}
}
\description{
Shows a plot with T2 vs Q values for data objects.
}
