% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discretize.R
\name{discretize}
\alias{discretize}
\title{A discretize Function}
\usage{
discretize(x, no.bin = 5)
}
\arguments{
\item{x}{Data frame.}

\item{no.bin}{Number of bin.
'FD' to use the Freedman-Diaconis rule for identifying number of bins.
The number of bin is 'max-min/2*IQR*n^-(1/3)'.
'ThreeStage' to discretize data into three stages.
1 if data is more than mu+sigma/2; 0=-1 if data is less than mu - sigma/2; otherwise 0.}
}
\value{
Return the discretized data
}
\description{
'discretize' function performs a basic discretization using binning.
}
\examples{
data(iris)
iris.bin = discretize(iris, no.bin = 5)
}
\author{
Saisakul Chernbumroong
}
