% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/targets.R
\name{calc_variance}
\alias{calc_variance}
\title{Calculate Variance and its Monte Carlo Standard Error}
\usage{
calc_variance(estimates)
}
\arguments{
\item{estimates}{A numeric vector of estimates from a simulation or sampling process.}
}
\value{
A list containing two elements: `variance`, the calculated sample variance of the estimates,
and `variance_mcse`, the Monte Carlo Standard Error of the variance. The MCSE provides a measure of
the uncertainty associated with the variance estimate, adjusted for kurtosis.
}
\description{
Computes the sample variance of a set of estimates and the Monte Carlo Standard Error (MCSE)
for the variance. The MCSE is adjusted by the sample kurtosis to account for the shape
of the distribution of the estimates. This function is particularly useful in simulation studies
where understanding the variability of an estimator and the precision of this variability estimate
is crucial.
}
\examples{
estimates <- rnorm(100, mean = 50, sd = 10)
variance_info <- calc_variance(estimates)
print(variance_info)
}
