% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\encoding{UTF-8}
\name{pp_check}
\alias{pp_check}
\alias{pp_check.mcpfit}
\title{Posterior Predictive Checks For Mcpfit Objects}
\usage{
pp_check(
  object,
  type = "dens_overlay",
  facet_by = NULL,
  newdata = NULL,
  prior = FALSE,
  varying = TRUE,
  arma = TRUE,
  nsamples = 100,
  ...
)
}
\arguments{
\item{object}{An \code{mcpfit} object.}

\item{type}{One of \code{bayesplot::available_ppc("grouped", invert = TRUE) \%>\% stringr::str_remove("ppc_")}}

\item{facet_by}{Name of a column in data modeled as varying effect(s).}

\item{newdata}{A \code{tibble} or a \code{data.frame} containing predictors in the model. If \code{NULL} (default),
the original data is used.}

\item{prior}{TRUE/FALSE. Plot using prior samples? Useful for \code{mcp(..., sample = "both")}}

\item{varying}{One of:
\itemize{
\item \code{TRUE} All varying effects (\code{fit$pars$varying}).
\item \code{FALSE} No varying efects (\code{c()}).
\item Character vector: Only include specified varying parameters - see \code{fit$pars$varying}.
}}

\item{arma}{Whether to include autoregressive effects.
\itemize{
\item \code{TRUE} Compute autoregressive residuals. Requires the response variable in \code{newdata}.
\item \code{FALSE} Disregard the autoregressive effects. For \code{family = gaussian()}, \code{predict()} just use \code{sigma} for residuals.
}}

\item{nsamples}{Number of draws. Note that you may want to use all data for summary geoms.
e.g., \code{pp_check(fit, type = "ribbon", nsamples = NULL)}.}

\item{...}{Further arguments passed to \code{bayesplot::ppc_type(y, yrep, ...)}}
}
\value{
A \code{ggplot2} object for single plots. Enriched by \code{patchwork} for faceted plots.
}
\description{
Plot posterior (default) or prior (\code{prior = TRUE}) predictive checks. This is convenience wrapper
around the \verb{bayesplot::ppc_*()} methods.
}
\examples{
\donttest{
pp_check(demo_fit)
pp_check(demo_fit, type = "ecdf_overlay")
#pp_check(some_varying_fit, type = "loo_intervals", facet_by = "id")
}

}
\seealso{
\code{\link{plot.mcpfit}} \code{\link{pp_eval}}
}
\author{
Jonas Kristoffer Lindeløv \email{jonas@lindeloev.dk}
}
