% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conjugate_gradients.R
\name{CG}
\alias{CG}
\title{Solve Ax=b by preconditioned conjugate gradients}
\usage{
CG(
  b,
  env,
  x = 0 * b,
  max.it = length(b),
  e = 1e+06 * length(b),
  verbose = FALSE,
  ...
)
}
\arguments{
\item{b}{right hand side vector.}

\item{env}{environment containing at least a function \code{A_times} that computes
the matrix-vector product Ax for some input vector x, and a function \code{M_solve}
that computes M^-1 x for some preconditioner matrix M.}

\item{x}{start value for the conjugate gradient algorithm.}

\item{max.it}{maximum number of iterations.}

\item{e}{total squared error stop criterion.}

\item{verbose}{whether progress information is shown.}

\item{...}{any parameters passed to \code{A_times} and \code{M_solve}.}
}
\value{
The (approximated) solution to Ax=b.
}
\description{
Solve Ax=b by preconditioned conjugate gradients
}
\references{
M.R. Hestenes and E. Stiefel (1952).
   Methods of conjugate gradients for solving linear systems.
   Journal of Research of the National Bureau of Standards 49(6), 409-436.
}
\keyword{internal}
