% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s.m.mcmc.R
\name{s.m.mcmc}
\alias{s.m.mcmc}
\title{MCMC Ensemble sampler with the stretch move (emcee)}
\usage{
s.m.mcmc(f, lower.inits, upper.inits, max.iter, n.walkers, ...)
}
\arguments{
\item{f}{function that returns a single scalar value proportional to the log
probability density to sample from.}

\item{lower.inits}{vector specifying for each parameter the lower value the
initial distribution.}

\item{upper.inits}{vector specifying for each parameter the upper value the
initial distribution.}

\item{max.iter}{maximum number of function evaluations}

\item{n.walkers}{number of walkers (ensemble size)}

\item{...}{further arguments passed to \code{f}}
}
\value{
List containing:
\itemize{
\item \code{samples[n.walkers,chain.length,n.dim]}
\item \code{log.p[n.walkers,chain.length]}
}
}
\description{
Markov Chain Monte Carlo sampler: using the stretch move (implementation of
the Goodman and Ware emcee)
}
\references{
Goodman, J. and Weare, J. (2010) Ensemble samplers with affine invariance.
Communications in Applied Mathematics and Computational Science, 5(1), 65–80,
\doi{10.2140/camcos.2010.5.65}
}
\author{
Sanda Dejanic
}
