% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mblogit.R
\name{mblogit}
\alias{fitted.mblogit}
\alias{mblogit}
\alias{predict.mblogit}
\alias{print.mblogit}
\alias{print.summary.mblogit}
\alias{summary.mblogit}
\title{Multinomial (Baseline) Logit Models for Categorical and Multinommial Responses}
\usage{
mblogit(formula, data = parent.frame(), subset, weights = NULL,
  na.action = getOption("na.action"), model = TRUE, x = FALSE, y = TRUE,
  contrasts = NULL, control = mclogit.control(...), ...)
}
\arguments{
\item{formula}{the model formula. The response must be a factor or a matrix
of counts.}

\item{data}{an optional data frame, list or environment (or object
coercible by \code{\link{as.data.frame}} to a data frame) containing
the variables in the model.  If not found in \code{data}, the
variables are taken from \code{environment(formula)},
typically the environment from which \code{glm} is called.}

\item{subset}{an optional vector specifying a subset of observations to be
used in the fitting process.}

\item{weights}{an optional vector of weights to be used in the fitting
process.  Should be \code{NULL} or a numeric vector.}

\item{na.action}{a function which indicates what should happen
when the data contain \code{NA}s.  The default is set by
the \code{na.action} setting of \code{\link{options}}, and is
\code{\link{na.fail}} if that is unset.  The \sQuote{factory-fresh}
default is \code{\link{na.omit}}.  Another possible value is
\code{NULL}, no action.  Value \code{\link{na.exclude}} can be useful.}

\item{model}{a logical value indicating whether \emph{model frame}
should be included as a component of the returned value.}

\item{x,y}{logical values indicating whether the response vector and model
matrix used in the fitting process should be returned as components
of the returned value.}

\item{contrasts}{an optional list. See the \code{contrasts.arg}
of \code{model.matrix.default}.}

\item{control}{a list of parameters for the fitting process.
See \code{\link{mclogit.control}}}

\item{\dots}{arguments to be passed to \code{mclogit.control}}
}
\value{
\code{mblogit} returns an object of class "mblogit", which has almost the
same structure as an object of class "\link[stats]{glm}". The difference are
the components \code{coefficients}, \code{residuals}, \code{fitted.values},
\code{linear.predictors}, and \code{y}, which are matrices with
number of columns equal to the number of response categories minus one.
}
\description{
The function \code{mblogit} fits multinomial logit models for categorical
and multinomial count responses with fixed alternatives, where the logits are
relative to a baseline category.
}
\details{
The function \code{mblogit} internally rearranges the data
into a 'long' format and uses \code{\link{mclogit.fit}} to compute
estimates. Nevertheless, the 'user data' is unaffected.
}

