% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcgf.R
\name{mcgf}
\alias{mcgf}
\title{Create mcgf object}
\usage{
mcgf(data, locations, dists, time)
}
\arguments{
\item{data}{Time series data set in space-wide format.}

\item{locations}{A matrix of data.frame of 2D points, first column
longitude, second column latitude, both in decimal degrees. Required when
\code{dists} is not supplied.}

\item{dists}{List of signed distance matrices. Required when \code{locations} is
not supplied.}

\item{time}{Optional, a vector of equally spaced time stamps.}
}
\value{
An S3 object of class \code{mcgf}. As it inherits and extends the
\code{data.frame} class, all methods remain valid to the \code{data} part of the
object. Additional attributes may be assigned and extracted.
}
\description{
Create mcgf object
}
\details{
An \code{mcgf} object extends the S3 class \code{data.frame}.

For inputs, \code{data} must be in space-wide format where rows correspond to
different time stamps and columns refer to spatial locations. Supply either
\code{locations} or \code{dists}. \code{locations} is a matrix or data.frame of 2D points
with first column longitude and second column latitude. Both columns must be
in decimal degrees. Number of rows in \code{locations} must be the same as the
number of columns of \code{data}. \code{dists} must be a list of signed distance
matrices with names \code{h1}, \code{h2}, and \code{h}. If \code{h} is not given, it will be
calculated as the Euclidean distance of \code{h1} and \code{h2}. \code{time} is a vector of
equally spaced time stamps. If it is not supplied then \code{data} is assumed to
be temporally equally spaced.

An \code{mcgf} object extends the S3 class \code{data.frame}, all methods remain valid
to the \code{data} part of the object.
}
\examples{
data <- cbind(S1 = 1:5, S2 = 4:8, S3 = 5:9)
lon <- c(110, 120, 130)
lat <- c(50, 55, 60)
locations <- cbind(lon, lat)
obj <- mcgf(data, locations = locations)
print(obj, "locations")
}
