% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcgf_rs.R
\name{mcgf_rs}
\alias{mcgf_rs}
\title{Create mcgf_rs object}
\usage{
mcgf_rs(data, locations, dists, label, time)
}
\arguments{
\item{data}{Time series data set in space-wide format.}

\item{locations}{A matrix of data.frame of 2D points, first column
longitude, second column latitude, both in decimal degrees. Required when
\code{dists} is not supplied.}

\item{dists}{List of signed distance matrices. Required when \code{locations} is
not supplied.}

\item{label}{A vector of regime labels. Its length must be the same as
the number rows in \code{data}.}

\item{time}{Optional, a vector of equally spaced time stamps.}
}
\value{
An S3 object of class \code{mcgf_rs}. As it inherits and extends the
\code{mcgf} and then the\code{data.frame} class, all methods remain valid to the
\code{data} part of the object. Additional attributes may be assigned and
extracted.
}
\description{
Create mcgf_rs object
}
\details{
An \code{mcgf_rs} object extends the S3 classes \code{mcgf} and \code{data.frame}.

For inputs, \code{data} must be in space-wide format where rows correspond to
different time stamps and columns refer to spatial locations. Supply either
\code{locations} or \code{dists}. \code{locations} is a matrix or data.frame of 2D points
with first column longitude and second column latitude. Both columns must be
in decimal degrees. Number of rows in \code{locations} must be the same as the
number of columns of \code{data}. \code{dists} must be a list of signed distance
matrices with names \code{h1}, \code{h2}, and \code{h}. If \code{h} is not given, it will be
calculated as the Euclidean distance of \code{h1} and \code{h2}. \code{time} is a vector of
equally spaced time stamps. If it is not supplied then \code{data} is assumed to
be temporally equally spaced. \code{label} must be a vector containing regime
labels, and its length must be the same as the number of rows in \code{x}.

An \code{mcgf_rs} object extends the S3 classes \code{mcgf} and \code{data.frame}, all
methods remain valid to the \code{data} part of the object.
}
\examples{
data <- cbind(S1 = 1:5, S2 = 4:8, S3 = 5:9)
lon <- c(110, 120, 130)
lat <- c(50, 55, 60)
locations <- cbind(lon, lat)
label <- c(1, 1, 2, 2, 2)
obj <- mcgf_rs(data, locations = locations, label = label)
print(obj, "locations")
print(obj, "label")
}
