% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcbette.R
\docType{package}
\name{mcbette}
\alias{mcbette}
\title{mcbette: Model Comparison Using Babette}
\description{
'mcbette' does a model comparing using \link[babette]{babette},
where the models are Bayesian phylogenetic models,
as created by \link[beautier]{create_inference_model}.
}
\details{
The main function is \link{est_marg_liks},
which estimate the marginal likelihoods (aka evidence)
for one or more inference models, based on a single alignment.
Also, the marginal likelihoods are compared, resulting in a
relative weight for each model, where a relative weight of a model
close to \code{1.0} means that that model is way likelier than
the others.

In the process, multiple (temporary) files are created (where
\code{[x]} denotes the index in a list)

\itemize{
  \item \code{beast2_optionses[x]$input_filename}
    path to the the BEAST2 XML input file
  \item \code{beast2_optionses[x]$output_state_filename}
    path to the BEAST2 XML state file
  \item \code{inference_models[x]$mcmc$tracelog$filename}
    path to the BEAST2 trace file with parameter estimates
  \item \code{inference_models[x]$mcmc$treelog$filename}
    path to the BEAST2 \code{trees} file with the posterior trees
  \item \code{inference_models[x]$mcmc$screenlog$filename}
    path to the BEAST2 screen output file
}

These file can be deleted manually by \link[babette]{bbt_delete_temp_files},
else these will be deleted automatically by the operating system.
}
\examples{
if (can_run_mcbette()) {

  # An example FASTA file
  fasta_filename <- system.file("extdata", "simple.fas", package = "mcbette")

  inference_model_1 <- beautier::create_ns_inference_model(
    site_model = beautier::create_jc69_site_model()
  )
  inference_model_2 <- beautier::create_ns_inference_model(
    site_model = beautier::create_gtr_site_model()
  )

  # Shorten the run, by doing a short (dirty, unreliable) MCMC
  inference_model_1$mcmc <- beautier::create_test_ns_mcmc()
  inference_model_2$mcmc <- beautier::create_test_ns_mcmc()

  inference_models <- c(list(inference_model_1), list(inference_model_2))

  # Estimate the marginal log-likelihoods of the two models
  marg_liks <- est_marg_liks(
    fasta_filename = fasta_filename,
    inference_models = inference_models
  )

  # Interpret the results
  interpret_marg_lik_estimates(marg_liks)
}
}
\seealso{
Use \link{can_run_mcbette} to see if 'mcbette' can run.
}
\author{
Richèl J.C. Bilderbeek
}
