% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{addCoordinates}
\alias{addCoordinates}
\title{Add node coordinates to graph.}
\usage{
addCoordinates(graph, n, generator, by.centers = FALSE, par.fun = NULL, ...)
}
\arguments{
\item{graph}{[\code{mcGP}]\cr
Multi-objective graph problem.}

\item{n}{[\code{integer}]\cr
Number of coordinates to place. If \code{by.centers} is \code{FALSE} a single
integer value is expected. Otherwise, a vector v may be passed. In this case
v[i] coordinates are generated for each cluster. However, if a single value is
passed and \code{by.center == TRUE}, each cluster is assigned the same number of
coordinates.}

\item{generator}{[\code{function(n, ...)}]\cr
Function used to generate coordinates. The generator needs to expect the number
of points to generate as the first argument \code{n}. Additional control argument are
possible.}

\item{by.centers}{[\code{logical(1)}]\cr
Should coordinates be placed for each cluster center seperately? This enables
geneation of clustered coordinates.
Default is \code{FALSE}.}

\item{par.fun}{[\code{function(cc) | NULL}]\cr
Optional function which is applied to each cluster center \code{cc} before the generation
of coordinates in case \code{by.centers} is \code{TRUE}. This enables to specifically
determine additional parameters for the \code{generator} for each cluster.}

\item{...}{[any]\cr
Furhter arguments passed down to \code{generator}.}
}
\value{
[\code{mcGP}] Multi-objective graph problem.
}
\description{
Places node coordinates in the two-dimensional euclidean plane.
}
\seealso{
Other graph generators: \code{\link{addCenters}},
  \code{\link{addWeights}}, \code{\link{mcGP}}
}
