\name{multimod1d}
\alias{multimod1d}
\title{Measure of one-dimensional multimodality
}
\encoding{UTF-8}
\description{A measure of one-dimensional multimodality based on p-values of the diptest. 
A jittering whose intensity depends on the value of \code{\link{discrete1d}} is used to prevent ties. 
The function \code{\link{dip.test}} from package \pkg{diptest} is used for calculating the p-value. 

}
\usage{
multimod1d(x, seed = NULL, exp = 1)
}

\arguments{
  \item{x}{ A numeric vector, a numeric matrix or a data frame.} 
  \item{seed}{An integer. The seed which is used for the jittering. If \code{NULL}, a fixed default value is used.}
  \item{exp}{A positive integer. Controls the sensitivity of the result with \code{(1-p-value)^exp} (see details).}

}

\details{
The specific result of the function depends on the seed, its default can be changed by setting \code{seed}. A normally distributed vector, generated by \code{rnorm} with \code{mean=0} and \code{sd=discrete1d(x)*sd(x,na.rm=T)/5}, is added to \code{x} to break ties.

To control the sensitivity of the measure an exponent can be choosen which influences the value by \code{(1-p-value)^exp}. Higher values of \code{exp} are recommended if a data set has a huge number of multimodal variables. Higher values makes it easier to seperate clear multimodal structures from not so clear ones. For example an exponent of \code{10} implies a value of \code{0.6} when \code{(1-p-value)^exp=0.95} (this is the value for \code{exp=1}).
}
\value{
A single value or a vector including the results of \code{skew1d} for each variable (in case of numeric matrices or data frames). If variables from data frames are categorical, 'NA' is returned.
}
\references{
M. Maechler (2015) diptest: Hartigan's Dip Test Statistic for Unimodality - Corrected.
    \url{https://CRAN.R-project.org/package=diptest}.

J. A. Hartigan and P. M. Hartigan (1985) The Dip Test of Unimodality. \emph{Annals of Statistics} \bold{13}(1), 70--84.

P. M. Hartigan (1985) 
Algorithm AS 217: Computation of the Dip Statistic to Test for Unimodality. \emph{Journal of the Royal Statistical Society. Series C (Applied Statistics)} \bold{34}(3), 320–325.
}
\author{
Katrin Grimm
}


\seealso{
\code{\link{skew1d}}, \code{\link{discrete1d}}, \code{\link{iaunivariate}} 
}
\examples{
data(Election2005)
\dontrun{
multimod <- multimod1d(Election2005)
maxv <- order(multimod,decreasing=TRUE)[1:4]
par(mfrow=c(2,2))
for(i in 1:4){
  hist(Election2005[,maxv[i]],xlab="",breaks=30,
  main=paste(names(Election2005[maxv[i]])))
}

# Explore skewness, multimodality and discreteness within interactive environment.
iaunivariate(Election2005)
}
}
\keyword{one-dimensional meausures}
