% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataframe.R
\name{ms_to_df}
\alias{ms_to_df}
\title{Convert matrixset to data frame}
\usage{
ms_to_df(
  .ms,
  add_row_info = TRUE,
  add_column_info = TRUE,
  as_list = FALSE,
  .matrix = NULL
)
}
\arguments{
\item{.ms}{\code{matrixset} object to convert to \code{data.frame}}

\item{add_row_info}{\code{logical}, to include row annotation or not}

\item{add_column_info}{\code{logical}, to include column annotation or not}

\item{as_list}{\code{logical}. By default (\code{FALSE}), a single tibble
is returned with matrices as columns. When \code{TRUE},
the list structure, an element by converted matrix,
is kept.}

\item{.matrix}{matrix indices of which matrix to include in the
conversion. The default, \code{NULL}, means all the
matrices are used.

If not \code{NULL}, index is numeric or character vectors.

Numeric values are coerced to integer as by \code{\link[=as.integer]{as.integer()}} (and hence
truncated towards zero).

Character vectors will be matched to the matrix names of the object.

Can also be logical vectors, indicating elements/slices to replace. Such
vectors are \emph{NOT} recycled, which is an important difference with usual
matrix replacement. It means that the \code{logical} vector must match the
number of matrices in length.

Can also be negative integers, indicating elements/slices to leave out of
the replacement.}
}
\value{
A tibble, or if \code{as_list} is \code{TRUE}, A \code{list} of data frames, an element per
converted matrix
}
\description{
Converts a \code{matrixset} to a \code{data.frame} (a \code{tibble}, more specifically), in
a long format.

When \code{as_list} is \code{TRUE}, each matrix is converted separately. Row/column
annotation is included if requested.
}
\examples{
# includes both annotation
ms_to_df(student_results)

# includes only row annotation
ms_to_df(student_results, add_column_info = FALSE)

}
