% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixpls.blindfold.R
\name{matrixpls.blindfold}
\alias{matrixpls.blindfold}
\title{Blindfold crossvalidation of predictions from matrixpls results}
\usage{
matrixpls.blindfold(data, ..., predictFun = stats::predict, nGroup = 4)
}
\arguments{
\item{data}{Matrix or data frame containing the raw data.}

\item{...}{All other arguments are passed through to \code{\link{matrixpls}}.}

\item{predictFun}{The function used to calculate the predictions.}

\item{nGroup}{The number of groups to divide the data into. Setting \code{nGroup} to the number
of observations produces jackknife predictions.}
}
\value{
A matrix of class \code{matrixpls.blindfold} containing predictions calculated with 
blindfolding.
}
\description{
\code{matrixpls.blindfold} Calculates blindfold predictions using \code{matrixpls}.
}
\details{
In blindfolding, the data are first divided into n equal sized groups. Then a 
statistic or a model is estimated using the data after omitting one of the groups.
The results are then used to predict the observations in that group. The process is repeated when
all groups have been predicted.
}

