% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec.R
\name{vec}
\alias{vec}
\title{Stacks a Matrix using matrix operator "vec"}
\usage{
vec(A, use.Names = TRUE)
}
\arguments{
\item{A}{a matrix}

\item{use.Names}{logical. If TRUE, the names of A are taken to be names of the stacked matrix. Default: TRUE.}
}
\value{
A vector with mn elements.
}
\description{
Returns a column vector that is a stack of the columns of A, an m by n matrix.
}
\note{
Adapted from Frederick Novomestky's \pkg{matrixcalc}. This function is edited so that it can take dimension names and return as a vector.
}
\examples{
M <- matrix(c(4,5,6,7,8,9), nrow=3)
M
#Compare vec from \\pkg{matrixcalc} and new function.
matrixcalc::vec(M)
vec(M)
#The names are rownames(M):colnames(M) in that order.
#Very similar to matrixcalc but dimension names are different.
}
\references{
Magnus, J. R. and H. Neudecker (1999). \emph{Matrix Differential Calculus with Applications in Statistics and Econometrics.} Second Edition, John Wiley, ed.
}
\seealso{
Other distribution: \code{\link{matrixNormal_Distribution}}
}
\concept{distribution}
\keyword{distribution}
\keyword{matrix}
