% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_filter.R
\name{sim_filter_all_same_keep_some}
\alias{sim_filter_all_same_keep_some}
\title{Filter a melted similarity matrix to keep pairs with the same values in
specific columns, and keep only some of these pairs.}
\usage{
sim_filter_all_same_keep_some(
  sim_df,
  row_metadata,
  all_same_cols,
  filter_keep_right,
  annotation_cols = NULL,
  drop_reference = TRUE,
  sim_cols = c("id1", "id2", "sim")
)
}
\arguments{
\item{sim_df}{data.frame with melted similarity matrix.}

\item{row_metadata}{data.frame with row metadata.}

\item{all_same_cols}{character vector specifying columns.}

\item{filter_keep_right}{data.frame of metadata specifying which rows to
keep on the right index.}

\item{annotation_cols}{optional character vector specifying which columns
from \code{metadata} to annotate the left index of the filtered
\code{sim_df} with.}

\item{drop_reference}{optional boolean specifying whether to filter (drop)
pairs using \code{filter_keep_right} on the left index.}

\item{sim_cols}{optional character string specifying minimal set of columns
for a similarity matrix}
}
\value{
Filtered \code{sim_df} as a data.frame, where only pairs with the
same values in \code{all_same_cols} columns are kept, with further filtering
using \code{filter_keep_right}.Rows are annotated based on the first index,
if specified.
}
\description{
\code{sim_filter_all_same} filters a melted similarity matrix to keep pairs
with the same values in specific columns, keeping only some of these pairs.
}
\examples{
suppressMessages(suppressWarnings(library(magrittr)))
n <- 20
population <- tibble::tibble(
  Metadata_group = sample(c("a", "b"), n, replace = TRUE),
  Metadata_type = sample(c("x", "y"), n, replace = TRUE),
  x = rnorm(n),
  y = x + rnorm(n) / 100,
  z = y + rnorm(n) / 1000
)
annotation_cols <- c("Metadata_group", "Metadata_type")
sim_df <- matric::sim_calculate(population, method = "pearson")
row_metadata <- attr(sim_df, "row_metadata")
sim_df <- matric::sim_annotate(sim_df, row_metadata, annotation_cols)
all_same_cols <- c("Metadata_group")
filter_keep_right <-
  tibble::tibble(Metadata_group = "a", Metadata_type = "x")
drop_reference <- FALSE
matric::sim_filter_all_same_keep_some(
  sim_df,
  row_metadata,
  all_same_cols,
  filter_keep_right,
  annotation_cols,
  drop_reference
)
}
