/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.search.measure;

import choco.kernel.solver.search.measure.IMeasures;
import choco.kernel.solver.search.measure.ISearchMeasures;

public class MeasuresBean
implements IMeasures {
    public int solutionCount;
    public int objectiveIntValue = Integer.MAX_VALUE;
    public double objectiveRealValue = Double.POSITIVE_INFINITY;
    public boolean objectiveOptimal;
    public int readingTime;
    public int initialPropTime;
    public int timeCount;
    public int nodeCount;
    public int backtrackCount;
    public int restartCount;
    public int failCount;

    public final void reset() {
        this.readingTime = 0;
        this.initialPropTime = 0;
        this.timeCount = 0;
        this.nodeCount = 0;
        this.backtrackCount = 0;
        this.restartCount = 0;
        this.failCount = 0;
    }

    public final void setSearchMeasures(ISearchMeasures toCopy) {
        this.timeCount = toCopy.getTimeCount();
        this.nodeCount = toCopy.getNodeCount();
        this.backtrackCount = toCopy.getBackTrackCount();
        this.restartCount = toCopy.getRestartCount();
        this.failCount = toCopy.getFailCount();
    }

    @Override
    public boolean existsSolution() {
        return this.solutionCount > 0;
    }

    @Override
    public int getSolutionCount() {
        return this.solutionCount;
    }

    @Override
    public Number getObjectiveValue() {
        return this.objectiveIntValue == Integer.MAX_VALUE ? (Number)(this.objectiveRealValue == Double.POSITIVE_INFINITY ? (Number)null : (Number)this.objectiveRealValue) : (Number)this.objectiveIntValue;
    }

    @Override
    public boolean isObjectiveOptimal() {
        return this.objectiveOptimal;
    }

    @Override
    public final int getBackTrackCount() {
        return this.backtrackCount;
    }

    @Override
    public final int getFailCount() {
        return this.failCount;
    }

    @Override
    public final int getNodeCount() {
        return this.nodeCount;
    }

    @Override
    public int getReadingTimeCount() {
        return this.readingTime;
    }

    @Override
    public int getInitialPropagationTimeCount() {
        return this.initialPropTime;
    }

    @Override
    public final int getTimeCount() {
        return this.timeCount;
    }

    @Override
    public final int getRestartCount() {
        return this.restartCount;
    }

    public final void setSolutionCount(int solutionCount) {
        this.solutionCount = solutionCount;
    }

    public final void setObjectiveIntValue(int objectiveIntValue) {
        this.objectiveIntValue = objectiveIntValue;
    }

    public final void setObjectiveRealValue(double objectiveRealValue) {
        this.objectiveRealValue = objectiveRealValue;
    }

    public final void setObjectiveOptimal(boolean objectiveOptimal) {
        this.objectiveOptimal = objectiveOptimal;
    }

    public final void setRestartCount(int restartCount) {
        this.restartCount = restartCount;
    }

    public void setReadingTimeCount(int readingTimeCount) {
        this.readingTime = readingTimeCount;
    }

    public void setInitialPropagationTimeCount(int initialPropagationTimeCount) {
        this.initialPropTime = initialPropagationTimeCount;
    }

    public final void setTimeCount(int timeCount) {
        this.timeCount = timeCount;
    }

    public final void setNodeCount(int nodeCount) {
        this.nodeCount = nodeCount;
    }

    public final void setBacktrackCount(int backtrackCount) {
        this.backtrackCount = backtrackCount;
    }

    public final void setIterationCount(int iterationCount) {
        this.restartCount = iterationCount;
    }

    public final void setFailCount(int failCount) {
        this.failCount = failCount;
    }
}

