/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.variables.geost;

import choco.kernel.model.variables.MultipleVariables;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.integer.IntegerVariable;

public class GeostObject
extends MultipleVariables {
    private final int dim;
    private final int objectId;
    private final IntegerVariable shapeId;
    private final IntegerVariable[] coordinates;
    private final IntegerVariable startTime;
    private final IntegerVariable durationTime;
    private final IntegerVariable endTime;
    private final int radius;

    public GeostObject(int dim, int objectId, IntegerVariable shapeId, IntegerVariable[] coordinates, IntegerVariable startTime, IntegerVariable durationTime, IntegerVariable endTime) {
        this(dim, objectId, shapeId, coordinates, startTime, durationTime, endTime, -1);
    }

    public GeostObject(int dim, int objectId, IntegerVariable shapeId, IntegerVariable[] coordinates, IntegerVariable startTime, IntegerVariable durationTime, IntegerVariable endTime, int radius) {
        this.dim = dim;
        this.objectId = objectId;
        this.shapeId = shapeId;
        this.coordinates = coordinates;
        this.startTime = startTime;
        this.durationTime = durationTime;
        this.endTime = endTime;
        this.radius = radius;
        Variable[] vars = new Variable[coordinates.length + 3];
        vars[0] = shapeId;
        System.arraycopy(coordinates, 0, vars, 1, coordinates.length);
        vars[vars.length - 3] = startTime;
        vars[vars.length - 2] = durationTime;
        vars[vars.length - 1] = endTime;
        this.setVariables(vars);
    }

    public int getDim() {
        return this.dim;
    }

    public int getObjectId() {
        return this.objectId;
    }

    public IntegerVariable getShapeId() {
        return this.shapeId;
    }

    public IntegerVariable[] getCoordinates() {
        return this.coordinates;
    }

    public IntegerVariable getStartTime() {
        return this.startTime;
    }

    public IntegerVariable getDurationTime() {
        return this.durationTime;
    }

    public IntegerVariable getEndTime() {
        return this.endTime;
    }

    public int getRadius() {
        return this.radius;
    }

    public boolean isSphere() {
        return this.radius != -1;
    }
}

