/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.goals.choice;

import choco.cp.solver.goals.GoalHelper;
import choco.cp.solver.search.integer.valselector.MinVal;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.goals.Goal;
import choco.kernel.solver.goals.GoalType;
import choco.kernel.solver.search.ValIterator;
import choco.kernel.solver.search.ValSelector;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class Instantiate
implements Goal {
    protected IntDomainVar var;
    protected ValSelector<IntDomainVar> valSelector;
    protected ValIterator<IntDomainVar> valIterator;
    protected int previousVal = Integer.MAX_VALUE;

    public Instantiate(IntDomainVar var, ValSelector<IntDomainVar> s) {
        this.var = var;
        this.valSelector = s;
    }

    public Instantiate(IntDomainVar var, ValIterator<IntDomainVar> valIterator) {
        this.var = var;
        this.valIterator = valIterator;
    }

    public Instantiate(IntDomainVar var) {
        this.var = var;
        this.valSelector = new MinVal();
    }

    @Override
    public String pretty() {
        return "Instantiate " + this.var.pretty();
    }

    @Override
    public Goal execute(Solver s) throws ContradictionException {
        if (this.var.isInstantiated()) {
            return null;
        }
        int val = -1;
        if (this.valIterator != null) {
            if (this.previousVal == Integer.MAX_VALUE) {
                val = this.valIterator.getFirstVal(this.var);
            } else if (this.valIterator.hasNextVal(this.var, this.previousVal)) {
                val = this.valIterator.getNextVal(this.var, this.previousVal);
            }
            this.previousVal = val;
        } else {
            val = this.valSelector.getBestVal(this.var);
        }
        return GoalHelper.or(GoalHelper.setVal(this.var, val), GoalHelper.and(GoalHelper.remVal(this.var, val), this));
    }

    @Override
    public GoalType getType() {
        return GoalType.INST;
    }
}

