% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circle_sections_figures.R
\name{semi_circle_bottom_inv}
\alias{semi_circle_bottom_inv}
\alias{semi_circle_bottom}
\title{Coordinates of an upward-facing left semi-circle}
\usage{
semi_circle_bottom_inv(
  size.x = sqrt(square()$size.x[[1]]^2/2),
  size.y = 0,
  pos.x = 0,
  pos.y = 0,
  theta1 = 5 * pi/4,
  theta2 = pi/4,
  shd = NA,
  lty = 1,
  lwd = 3,
  vis = 1
)

semi_circle_bottom(
  size.x = sqrt(square()$size.x[[1]]^2/2),
  size.y = 0,
  pos.x = 0,
  pos.y = 0,
  theta1 = 3 * pi/4,
  theta2 = 7 * pi/4,
  shd = NA,
  lty = 1,
  lwd = 3,
  vis = 1
)
}
\arguments{
\item{size.x}{numeric, define the semi-major axis of the ellipse  within which the figure is inscribed. Default is sqrt(square()$ size.x[[1]]^2 /2)}

\item{size.y}{numeric, define the semi-minor axis of the ellipse  within which the figure is inscribed. Default is 0}

\item{pos.x}{numeric, position on the x axis. Default is 0}

\item{pos.y}{numeric, position the y axis, Default is 0}

\item{theta1}{Starting angle of the circle section. Default is 3*pi/4.}

\item{theta2}{Ending angle of the circle section (built counterclockwise). Default is 7*pi/4.}

\item{shd}{character, define the shading of the figure. Default is NA which results in a transparent figure}

\item{lty}{integer, define the line type of the figure, default is 1 (solid line)}

\item{lwd}{integer, define the line width of the figure. Default is 3}

\item{vis}{Visibility of the figure. Default is 1, making the figure visible. To hide the figure, change it to 0}
}
\value{
The coordinates for drawing an upward-facing left semi-circle

The coordinates a upward-facing left semi-circle
}
\description{
Define the coordinates for drawing an upward-facing left semi-circle
}
\section{Functions}{
\itemize{
\item \code{semi_circle_bottom_inv()}: Coordinates of an upward-facing right semi-circle

Define the coordinates fr drawing an upward-facing right semi-circle

}}
\examples{
# default coordinates of the upward-facing right semi-circle
semi_circle_bottom_inv()
# change the rotation of the upward-facing right semi-circle
semi_circle_bottom_inv(theta1 = pi, theta2 = 2*pi)
# default coordinates of the upward-facing left semi-circle
semi_circle_bottom()
# change the rotation of the upward-facing left semi-circle
semi_circle_bottom(theta1 = pi, theta2 = 2*pi)
}
