% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/massprops.R
\name{rollup_mass_props}
\alias{rollup_mass_props}
\title{Roll up mass properties}
\usage{
rollup_mass_props(tree, df, validate_df = validate_mass_props_table, ...)
}
\arguments{
\item{tree}{An 'igraph' tree whose vertices are named as the values of the \code{id}
column of \code{df} and whose directed edges point from child id to parent id.}

\item{df}{A data frame  with (at least) these columns: \code{id}, \code{mass}, \code{Cx},
\code{Cy}, \code{Cz}, \code{Ixx}, \code{Iyy}, \code{Izz}, \code{Ixy}, \code{Ixz}, \code{Iyz}, \code{POIconv}, \code{Ipoint}.}

\item{validate_df}{A validator for the tree and table, default \code{validate_mass_props_table()}}

\item{...}{Other parameters passed to \code{rollupTree::rollup()}}
}
\value{
The updated data frame
}
\description{
'rollup_mass_props()' rolls up mass properties in a data frame such that the mass properties of each
non-leaf vertex element is the aggregation of those of its child elements.
}
\examples{
rollup_mass_props(mp_tree, mp_table)[1:100, ]

}
