# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

.isProbRcpp <- function(prob) {
    .Call('_markovchain_isProb', PACKAGE = 'markovchain', prob)
}

.isGenRcpp <- function(gen) {
    .Call('_markovchain_isGen', PACKAGE = 'markovchain', gen)
}

.canonicFormRcpp <- function(object) {
    .Call('_markovchain_canonicForm', PACKAGE = 'markovchain', object)
}

.lexicographical_sort <- function(y) {
    .Call('_markovchain_lexicographicalSort', PACKAGE = 'markovchain', y)
}

generatorToTransitionMatrix <- function(gen, byrow = TRUE) {
    .Call('_markovchain_generatorToTransitionMatrix', PACKAGE = 'markovchain', gen, byrow)
}

ctmcFit <- function(data, byrow = TRUE, name = "", confidencelevel = 0.95) {
    .Call('_markovchain_ctmcFit', PACKAGE = 'markovchain', data, byrow, name, confidencelevel)
}

.ExpectedTimeRCpp <- function(x, y) {
    .Call('_markovchain_ExpectedTimeRcpp', PACKAGE = 'markovchain', x, y)
}

.probabilityatTRCpp <- function(y) {
    .Call('_markovchain_probabilityatTRCpp', PACKAGE = 'markovchain', y)
}

.impreciseProbabilityatTRCpp <- function(C, i, t, s, error) {
    .Call('_markovchain_impreciseProbabilityatTRCpp', PACKAGE = 'markovchain', C, i, t, s, error)
}

seq2freqProb <- function(sequence) {
    .Call('_markovchain_seq2freqProb', PACKAGE = 'markovchain', sequence)
}

seq2matHigh <- function(sequence, order) {
    .Call('_markovchain_seq2matHigh', PACKAGE = 'markovchain', sequence, order)
}

.markovchainSequenceRcpp <- function(n, markovchain, t0, include_t0 = FALSE) {
    .Call('_markovchain_markovchainSequenceRcpp', PACKAGE = 'markovchain', n, markovchain, t0, include_t0)
}

.markovchainListRcpp <- function(n, object, include_t0 = FALSE, t0 = character()) {
    .Call('_markovchain_markovchainListRcpp', PACKAGE = 'markovchain', n, object, include_t0, t0)
}

.markovchainSequenceParallelRcpp <- function(listObject, n, include_t0 = FALSE, init_state = character()) {
    .Call('_markovchain_markovchainSequenceParallelRcpp', PACKAGE = 'markovchain', listObject, n, include_t0, init_state)
}

#' @rdname markovchainFit
#' 
#' @export
createSequenceMatrix <- function(stringchar, toRowProbs = FALSE, sanitize = FALSE, possibleStates = character()) {
    .Call('_markovchain_createSequenceMatrix', PACKAGE = 'markovchain', stringchar, toRowProbs, sanitize, possibleStates)
}

.mcListFitForList <- function(data) {
    .Call('_markovchain_mcListFitForList', PACKAGE = 'markovchain', data)
}

.matr2Mc <- function(matrData, laplacian = 0, sanitize = FALSE, possibleStates = character()) {
    .Call('_markovchain__matr2Mc', PACKAGE = 'markovchain', matrData, laplacian, sanitize, possibleStates)
}

.list2Mc <- function(data, laplacian = 0, sanitize = FALSE) {
    .Call('_markovchain__list2Mc', PACKAGE = 'markovchain', data, laplacian, sanitize)
}

#' @name inferHyperparam
#' @title Function to infer the hyperparameters for Bayesian inference from an a priori matrix or a data set
#' @description Since the Bayesian inference approach implemented in the package is based on conjugate priors, 
#'              hyperparameters must be provided to model the prior probability distribution of the chain 
#'              parameters. The hyperparameters are inferred from a given a priori matrix under the assumption 
#'              that the matrix provided corresponds to the mean (expected) values of the chain parameters. A 
#'              scaling factor vector must be provided too. Alternatively, the hyperparameters can be inferred 
#'              from a data set. 
#'              
#' @param transMatr A valid transition matrix, with dimension names.
#' @param scale A vector of scaling factors, each element corresponds to the row names of the provided transition 
#'              matrix transMatr, in the same order. 
#' @param data A data set from which the hyperparameters are inferred.  
#' 
#' @details transMatr and scale need not be provided if data is provided.
#' @return Returns the hyperparameter matrix in a list.
#' 
#' @note The hyperparameter matrix returned is such that the row and column names are sorted alphanumerically, 
#'       and the elements in the matrix are correspondingly permuted. 
#' 
#' @references Yalamanchi SB, Spedicato GA (2015). Bayesian Inference of First Order Markov Chains. R
#'             package version 0.2.5       
#'             
#' @author Sai Bhargav Yalamanchi, Giorgio Spedicato
#' @seealso \code{\link{markovchainFit}}, \code{\link{predictiveDistribution}}
#' 
#' @examples
#' data(rain, package = "markovchain")
#' inferHyperparam(data = rain$rain)
#'  
#' weatherStates <- c("sunny", "cloudy", "rain")
#' weatherMatrix <- matrix(data = c(0.7, 0.2, 0.1, 
#'                                  0.3, 0.4, 0.3, 
#'                                  0.2, 0.4, 0.4), 
#'                         byrow = TRUE, nrow = 3, 
#'                         dimnames = list(weatherStates, weatherStates))
#' inferHyperparam(transMatr = weatherMatrix, scale = c(10, 10, 10))
#'  
#' @export
#'  
inferHyperparam <- function(transMatr = matrix(), scale = numeric(), data = character()) {
    .Call('_markovchain_inferHyperparam', PACKAGE = 'markovchain', transMatr, scale, data)
}

#' @name markovchainFit
#' @title Function to fit a discrete Markov chain
#' @description Given a sequence of states arising from a stationary state, 
#'  it fits the underlying Markov chain distribution using either MLE (also using a 
#'  Laplacian smoother), bootstrap or by MAP (Bayesian) inference.
#'  
#' @param data It can be a character vector or a nx2 matrix or a nx2 data frame or a list
#' @param method Method used to estimate the Markov chain. Either "mle", "map", "bootstrap" or "laplace"
#' @param byrow it tells whether the output Markov chain should show the transition probabilities by row.
#' @param nboot Number of bootstrap replicates in case "bootstrap" is used.
#' @param laplacian Laplacian smoothing parameter, default zero. It is only used when "laplace" method 
#'                  is chosen.  
#' @param name Optional character for name slot. 
#' @param parallel Use parallel processing when performing Boostrap estimates.
#' @param confidencelevel \deqn{\alpha} level for conficence intervals width. 
#'                        Used only when \code{method} equal to "mle".
#' @param confint a boolean to decide whether to compute Confidence Interval or not.                       
#' @param hyperparam Hyperparameter matrix for the a priori distribution. If none is provided, 
#'                   default value of 1 is assigned to each parameter. This must be of size kxk 
#'                   where k is the number of states in the chain and the values should typically 
#'                   be non-negative integers.                        
#' @param stringchar It can be a nx2 matrix or a character vector or a list
#' @param toRowProbs converts a sequence matrix into a probability matrix
#' @param sanitize put 1 in all rows having rowSum equal to zero
#' @param possibleStates Possible states which are not present in the given sequence
#' 
#' @details Disabling confint would lower the computation time on large datasets. If \code{data} or \code{stringchar} 
#' contain \code{NAs}, the related \code{NA} containing transitions will be ignored.
#' 
#' @return A list containing an estimate, log-likelihood, and, when "bootstrap" method is used, a matrix 
#'         of standards deviations and the bootstrap samples. When the "mle", "bootstrap" or "map" method 
#'         is used, the lower and upper confidence bounds are returned along with the standard error. 
#'         The "map" method also returns the expected value of the parameters with respect to the 
#'         posterior distribution.
#' @references A First Course in Probability (8th Edition), Sheldon Ross, Prentice Hall 2010
#'             
#'             Inferring Markov Chains: Bayesian Estimation, Model Comparison, Entropy Rate, 
#'             and Out-of-Class Modeling, Christopher C. Strelioff, James P. Crutchfield, 
#'             Alfred Hubler, Santa Fe Institute
#' 
#'             Yalamanchi SB, Spedicato GA (2015). Bayesian Inference of First Order Markov Chains. R
#'             package version 0.2.5          
#'             
#' @author Giorgio Spedicato, Tae Seung Kang, Sai Bhargav Yalamanchi
#' @note This function has been rewritten in Rcpp. Bootstrap algorithm has been defined "euristically". 
#'       In addition, parallel facility is not complete, involving only a part of the bootstrap process.
#'       When \code{data} is either a \code{data.frame} or a \code{matrix} object, only MLE fit is 
#'       currently available.
#'       
#' @seealso \code{\link{markovchainSequence}}, \code{\link{markovchainListFit}}
#' @examples
#' sequence <- c("a", "b", "a", "a", "a", "a", "b", "a", "b", "a", "b", "a", "a", 
#'               "b", "b", "b", "a")        
#' sequenceMatr <- createSequenceMatrix(sequence, sanitize = FALSE)
#' mcFitMLE <- markovchainFit(data = sequence)
#' mcFitBSP <- markovchainFit(data = sequence, method = "bootstrap", nboot = 5, name = "Bootstrap Mc")
#'
#' na.sequence <- c("a", NA, "a", "b")
#' # There will be only a (a,b) transition        
#' na.sequenceMatr <- createSequenceMatrix(na.sequence, sanitize = FALSE)
#' mcFitMLE <- markovchainFit(data = na.sequence)
#' 
#' # data can be a list of character vectors
#' sequences <- list(x = c("a", "b", "a"), y = c("b", "a", "b", "a", "c"))
#' mcFitMap <- markovchainFit(sequences, method = "map")
#' mcFitMle <- markovchainFit(sequences, method = "mle")
#' @rdname markovchainFit
#' 
#' @export
#' 
markovchainFit <- function(data, method = "mle", byrow = TRUE, nboot = 10L, laplacian = 0, name = "", parallel = FALSE, confidencelevel = 0.95, confint = TRUE, hyperparam = matrix(), sanitize = FALSE, possibleStates = character()) {
    .Call('_markovchain_markovchainFit', PACKAGE = 'markovchain', data, method, byrow, nboot, laplacian, name, parallel, confidencelevel, confint, hyperparam, sanitize, possibleStates)
}

.noofVisitsDistRCpp <- function(matrix, i, N) {
    .Call('_markovchain_noofVisitsDistRCpp', PACKAGE = 'markovchain', matrix, i, N)
}

.commclassesKernelRcpp <- function(P) {
    .Call('_markovchain_commclassesKernel', PACKAGE = 'markovchain', P)
}

.communicatingClassesRcpp <- function(object) {
    .Call('_markovchain_communicatingClasses', PACKAGE = 'markovchain', object)
}

.recurrentClassesRcpp <- function(object) {
    .Call('_markovchain_recurrentClasses', PACKAGE = 'markovchain', object)
}

.commStatesFinderRcpp <- function(matr) {
    .Call('_markovchain_commStatesFinder', PACKAGE = 'markovchain', matr)
}

.summaryKernelRcpp <- function(object) {
    .Call('_markovchain_summaryKernel', PACKAGE = 'markovchain', object)
}

.firstpassageKernelRcpp <- function(P, i, n) {
    .Call('_markovchain_firstpassageKernel', PACKAGE = 'markovchain', P, i, n)
}

.firstPassageMultipleRCpp <- function(P, i, setno, n) {
    .Call('_markovchain_firstPassageMultipleRCpp', PACKAGE = 'markovchain', P, i, setno, n)
}

.expectedRewardsRCpp <- function(matrix, n, rewards) {
    .Call('_markovchain_expectedRewardsRCpp', PACKAGE = 'markovchain', matrix, n, rewards)
}

.expectedRewardsBeforeHittingARCpp <- function(matrix, s0, rewards, n) {
    .Call('_markovchain_expectedRewardsBeforeHittingARCpp', PACKAGE = 'markovchain', matrix, s0, rewards, n)
}

.gcdRcpp <- function(a, b) {
    .Call('_markovchain_gcd', PACKAGE = 'markovchain', a, b)
}

#' @rdname absorbingStates
#' 
#' @export
#' 
period <- function(object) {
    .Call('_markovchain_period', PACKAGE = 'markovchain', object)
}

predictiveDistribution <- function(stringchar, newData, hyperparam = matrix()) {
    .Call('_markovchain_predictiveDistribution', PACKAGE = 'markovchain', stringchar, newData, hyperparam)
}

priorDistribution <- function(transMatr, hyperparam = matrix()) {
    .Call('_markovchain_priorDistribution', PACKAGE = 'markovchain', transMatr, hyperparam)
}

.multinomialCIForRowRcpp <- function(x, confidencelevel) {
    .Call('_markovchain_multinomialCIForRow', PACKAGE = 'markovchain', x, confidencelevel)
}

.multinomialCIRcpp <- function(transMat, seqMat, confidencelevel) {
    .Call('_markovchain_multinomCI', PACKAGE = 'markovchain', transMat, seqMat, confidencelevel)
}

