% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/1_functions4Fitting.R
\name{markovchainListFit}
\alias{markovchainListFit}
\title{Fit a markovchainList}
\usage{
markovchainListFit(data, byrow = TRUE, laplacian = 0, name)
}
\arguments{
\item{data}{Either a matrix or a data.frame object.}

\item{byrow}{Indicates whether distinc stochastic processes trajectiories are shown in distinct rows.}

\item{laplacian}{Laplacian correction (default 0).}

\item{name}{Optional name.}
}
\value{
A list containing two slots:
estimate (the estimate)
name
}
\description{
Fit a markovchainList
}
\examples{
#using holson dataset
data(holson)
#fitting a single markovchain
singleMc<-markovchainFit(data=holson[,2:12])
#fitting a markovchainList
mclistFit<-markovchainListFit(data=holson[,2:12],name="holsonMcList")
}

