% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/market_model.R, R/market_fit.R
\name{market_quantities}
\alias{market_quantities}
\alias{demanded_quantities}
\alias{demanded_quantities,missing,market_model,ANY-method}
\alias{supplied_quantities}
\alias{supplied_quantities,missing,market_model,ANY-method}
\alias{demanded_quantities,market_fit,missing,missing-method}
\alias{supplied_quantities,market_fit,missing,missing-method}
\title{Estimated market quantities.}
\usage{
demanded_quantities(fit, model, parameters)

\S4method{demanded_quantities}{missing,market_model,ANY}(model, parameters)

supplied_quantities(fit, model, parameters)

\S4method{supplied_quantities}{missing,market_model,ANY}(model, parameters)

\S4method{demanded_quantities}{market_fit,missing,missing}(fit)

\S4method{supplied_quantities}{market_fit,missing,missing}(fit)
}
\arguments{
\item{fit}{A fitted model object.}

\item{model}{A model object.}

\item{parameters}{A vector of model's parameters.}
}
\value{
A vector with the demanded quantities evaluated at the given parameter
vector.
}
\description{
Estimated market quantities.
}
\details{
Calculates and returns the estimated demanded or supplied quantities for
each observation at the passed vector of parameters.
}
\section{Functions}{
\itemize{
\item \code{demanded_quantities}: Estimated demanded quantities.

\item \code{supplied_quantities}: Estimated supplied quantities.
}}

\examples{
\donttest{
fit <- diseq_basic(
  HS | RM | ID | TREND ~
  RM + TREND + W + CSHS + L1RM + L2RM + MONTH |
    RM + TREND + W + L1RM + MA6DSF + MA3DHF + MONTH,
  fair_houses(),
  correlated_shocks = FALSE
)

# get estimated demanded and supplied quantities
head(cbind(
  demanded_quantities(fit),
  supplied_quantities(fit)
))
}
}
