% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cjs_tmb.R
\name{cjs_tmb}
\alias{cjs_tmb}
\title{Fitting function for CJS models}
\usage{
cjs_tmb(x, ddl, dml, model_data = NULL, parameters, accumulate = TRUE,
  initial = NULL, method, hessian = FALSE, debug = FALSE,
  chunk_size = 1e+07, refit, itnmax = NULL, control = NULL, scale,
  crossed = TRUE, compile = TRUE, extra.args = NULL, reml,
  clean = FALSE, getreals = FALSE, prior = FALSE, prior.list = NULL,
  tmbfct = "f1", ...)
}
\arguments{
\item{x}{processed dataframe created by process.data}

\item{ddl}{list of dataframes for design data; created by call to
\code{\link{make.design.data}}}

\item{dml}{list of design matrices created by \code{\link{create.dm}} from
formula and design data}

\item{model_data}{a list of all the relevant data for fitting the model including
imat, Phi.dm,p.dm,Phi.fixed,p.fixed, and time.intervals. It is used to save values
and avoid accumulation again if the model was re-rerun with an additional call to cjs when
using autoscale or re-starting with initial values.  It is stored with returned model object.}

\item{parameters}{equivalent to \code{model.parameters} in \code{\link{crm}}}

\item{accumulate}{if TRUE will accumulate capture histories with common
value and with a common design matrix for Phi and p to speed up execution}

\item{initial}{list of initial values for parameters if desired; if each is a named vector
from previous run it will match to columns with same name}

\item{method}{method to use for optimization; see \code{optim}}

\item{hessian}{if TRUE will compute and return the hessian}

\item{debug}{if TRUE will print out information for each iteration}

\item{chunk_size}{specifies amount of memory to use in accumulating capture
histories; amount used is 8*chunk_size/1e6 MB (default 80MB)}

\item{refit}{non-zero entry to refit}

\item{itnmax}{maximum number of iterations}

\item{control}{control string for optimization functions}

\item{scale}{vector of scale values for parameters}

\item{crossed}{if TRUE it uses cjs.tpl or cjs_reml.tpl if reml=FALSE or TRUE respectively; if FALSE, then it uses cjsre which can use Gauss-Hermite integration}

\item{compile}{if TRUE forces re-compilation of tpl file}

\item{extra.args}{optional character string that is passed to admb if use.admb==TRUE}

\item{reml}{if set to TRUE uses cjs_reml if crossed}

\item{clean}{if TRUE, deletes the tpl and executable files for amdb if use.admb=T}

\item{getreals}{if TRUE, will compute real Phi and p values and std errors}

\item{prior}{if TRUE will expect vectors of prior values in list prior.list}

\item{prior.list}{which contains for normal distributions 1) mu_phi_prior: vector of mu values for phi_beta, 2) sigma_phi_prior: vector of sigma values for phi_beta,
3) mu_p_prior: vector of mu values for p_beta, 4) sigma_p_prior: vector of sigma values for p_beta, 5) random_mu_phi_prior: vector of mu values for ln sigma of random effects, 
6) random_sigma_phi_prior: vector of sigma values for ln sigma_phi, 7) random_mu_p_prior: vector of mu values for ln sigma_p, 8) random_sigma_p_prior: vector of sigma values for ln sigma_p.}

\item{tmbfct}{either "f1" - default or "f2" - any random effects treated as fixed effects or "f3" fixed effects fixed at mode and no random effects.}

\item{...}{any remaining arguments are passed to additional parameters
passed to \code{optim} or \code{\link{cjs.lnl}}}
}
\value{
The resulting value of the function is a list with the class of
crm,cjs such that the generic functions print and coef can be used.
Elements are 1) beta: named vector of parameter estimatesm 2) lnl: -2*log
likelihood, 3) AIC: lnl + 2* number of parameters, 4) convergence: result from \code{optim}; if 0 \code{optim} thinks it
converged, 5) count:\code{optim} results of number of function
evaluations, 6) reals: dataframe of data and real Phi and p estimates for
each animal-occasion excluding those that occurred before release, 7) vcv:var-cov matrix of betas if hessian=TRUE was set.
}
\description{
A function for computing MLEs for a specified Cormack-Jolly-Seber open
population capture-recapture model for processed dataframe \code{x} with
user specified formulas in \code{parameters} that create list of design
matrices \code{dml}. This function can be called directly but is most easily
called from \code{\link{crm}} that sets up needed arguments.
}
\details{
It is easiest to call \code{cjs} through the function \code{\link{crm}}.
Details are explained there.

Be cautious with this function at present.  It does not include many checks
to make sure values like fixed values will remain in the specified range of
the data.  Normally this would not be a big problem but because
\code{\link{cjs.lnl}} calls an external FORTRAN subroutine, if it gets a
subscript out of bounds, it will cause R to terminate.  So make sure to save
your workspace frequently if you use this function in its current
implementation.
}
\references{
Pledger, S., K. H. Pollock, et al. (2003). Open
capture-recapture models with heterogeneity: I. Cormack-Jolly-Seber model.
Biometrics 59(4):786-794.
}
\author{
Jeff Laake
}
