% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fact.R
\name{fact}
\alias{fact}
\alias{fact.default}
\alias{fact.character}
\alias{fact.numeric}
\alias{fact.integer}
\alias{fact.Date}
\alias{fact.POSIXt}
\alias{fact.logical}
\alias{fact.factor}
\alias{fact.fact}
\alias{fact.pseudo_id}
\alias{fact.haven_labelled}
\title{Factor}
\usage{
fact(x)

\method{fact}{default}(x)

\method{fact}{character}(x)

\method{fact}{numeric}(x)

\method{fact}{integer}(x)

\method{fact}{Date}(x)

\method{fact}{POSIXt}(x)

\method{fact}{logical}(x)

\method{fact}{factor}(x)

\method{fact}{fact}(x)

\method{fact}{pseudo_id}(x)

\method{fact}{haven_labelled}(x)
}
\arguments{
\item{x}{A vector of values}
}
\value{
A vector of equal length of \code{x} with class \code{fact} and \code{factor}.  If
\code{x} was \code{ordered}, that class is added in between.
}
\description{
Quickly create a factor
}
\details{
\code{fact()} can be about 5 times quicker than \code{factor()} or
\code{as.factor()} as it doesn't bother sorting the levels for non-numeric data
or have other checks or features.  It simply converts a vector to a factor
with all unique values as levels with \code{NA}s included.

\code{fact.factor()} will perform several checks on a factor to include \code{NA}
levels and to check if the levels should be reordered to conform with the
other methods.  The \code{fact.fact()} method simple returns \code{x}.
}
\section{level orders}{


The order of the levels may be adjusted to these rules depending on the class
of \code{x}:
\describe{
\item{\code{character}}{The order of appearance}
\item{\code{numeric}/\code{integer}/\code{Date}/\code{POSIXt}}{By the numeric order}
\item{\code{logical}}{As \code{TRUE}, \code{FALSE}, then \code{NA} if present}
\item{\code{factor}}{Numeric if levels can be safely converted, otherwise as
they are}
}
}

\seealso{
\code{\link[=as_ordered]{as_ordered()}}

Other factors: 
\code{\link{as_ordered}()},
\code{\link{char2fact}()},
\code{\link{drop_levels}()},
\code{\link{fact2char}()},
\code{\link{fact_na}()}
}
\concept{factors}
