% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapshot.R
\name{mapshot}
\alias{mapshot}
\title{Save mapview or leaflet map as HTML and/or image}
\usage{
mapshot(x, url = NULL, file = NULL, remove_url = TRUE, ...)
}
\arguments{
\item{x}{\code{mapview} or \code{leaflet} object.}

\item{url}{Output \code{.html} file. If not supplied and 'file' is specified,
a temporary index file will be created.}

\item{file}{Output \code{.png}, \code{.pdf}, or \code{.jpeg} file.}

\item{remove_url}{\code{logical}. If \code{TRUE} (default), the \code{.html}
file is removed once processing is completed. Only applies if 'url' is not
specified.}

\item{...}{Further arguments passed on to \code{\link{webshot}}.}
}
\description{
Save a mapview or leaflet map as \code{.html} index file or \code{.png},
\code{.pdf}, or \code{.jpeg} image.
}
\details{
mapshot can be used to save both leaflet and mapview maps as html or png
files or both.
NOTE 1: In case you want to save larger maps produced with mapview
(i.e. if you see the following warning:
"the supplied feature layer is quite, so using special rendering function
things may not behave as expected from a standard leaflet plot
i.e. you will likely need to zoom in to popup-qurey features") mapshot is
likely to fail. Try setting \code{selfcontained = FALSE} to avoid errors
and create a valid local html file.

NOTE 2: In case you want to save a map with popupGraphs or popupImages
the respective graph/image files will be located one level above the
specified target location. In case you want to move the html file, make
sure to also move the respective *-graphs folder one level above.
}
\examples{
\dontrun{
m <- mapview(breweries)

## create standalone .html
mapshot(m, url = paste0(getwd(), "/map.html"))

## create standalone .png; temporary .html is removed automatically unless
## 'remove_url = FALSE' is specified
mapshot(m, file = paste0(getwd(), "/map.png"))

## create .html and .png
mapshot(m, url = paste0(getwd(), "/map.html"),
        file = paste0(getwd(), "/map.png"))
}

}
\seealso{
\code{\link{webshot}}, \code{\link{saveWidget}}.
}
